/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PApplet;
import def.processing.core.PImage;
import fisica.FBody;
import fisica.FCircle;
import fisica.FConstantVolumeJoint;
import fisica.FWorld;
import fisica.Fisica;
import java.util.ArrayList;
import org.jbox2d.common.Vec2;

public class FBlob
extends FBody {
    protected ArrayList m_vertices;
    protected ArrayList m_vertexBodies;
    protected float m_damping = 0.0f;
    protected float m_frequency = 0.0f;
    protected float m_vertexSize = 0.4f;
    protected Vec2 m_force = new Vec2();
    protected float m_torque = 0.0f;
    protected float m_density = 1.0f;
    protected float m_restitution = 0.5f;
    protected float m_friction = 0.5f;
    protected boolean m_bullet = false;
    protected FConstantVolumeJoint m_joint;

    public FBlob() {
        this.m_vertices = new ArrayList();
        this.m_vertexBodies = new ArrayList();
    }

    @Override
    public void addToWorld(FWorld world) {
        int i;
        this.m_joint = new FConstantVolumeJoint();
        this.m_joint.setFrequency(this.m_frequency);
        this.m_joint.setDamping(this.m_damping);
        this.m_joint.updateStyle(this);
        for (i = 0; i < this.m_vertices.size(); ++i) {
            Vec2 p = Fisica.worldToScreen((Vec2)this.m_vertices.get(i));
            FCircle fb = new FCircle(this.getVertexSize());
            fb.setPosition(p.x, p.y);
            fb.setDensity(this.m_density);
            fb.setRestitution(this.m_restitution);
            fb.setFriction(this.m_friction);
            fb.setGroupIndex(this.m_groupIndex);
            fb.setFilterBits(this.m_filterBits);
            fb.setCategoryBits(this.m_categoryBits);
            fb.setState(this);
            this.m_vertexBodies.add(fb);
        }
        for (i = 0; i < this.m_vertexBodies.size(); ++i) {
            FBody fb = (FBody)this.m_vertexBodies.get(i);
            fb.setDrawable(false);
            fb.setParent(this);
            fb.setRotatable(false);
            world.add(fb);
            Vec2 f = Fisica.worldToScreen(this.m_force);
            fb.addForce(f.x, f.y);
            fb.addTorque(this.m_torque);
            this.m_joint.addBody(fb);
        }
        this.m_joint.setCollideConnected(false);
        world.add(this.m_joint);
    }

    @Override
    public void removeFromWorld() {
        this.m_joint.removeFromWorld();
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).removeFromWorld();
        }
    }

    public void addVertexBody(FBody b) {
        this.m_vertexBodies.add(b);
    }

    public void vertex(float x, float y) {
        this.m_vertices.add(Fisica.screenToWorld(x, y));
    }

    public float getVertexX(int i) {
        return Fisica.worldToScreen((Vec2)((Vec2)this.m_vertices.get((int)i))).x;
    }

    public float getVertexY(int i) {
        return Fisica.worldToScreen((Vec2)((Vec2)this.m_vertices.get((int)i))).y;
    }

    public void setAsCircle(float x, float y, float size, int vertexCount) {
        this.m_vertices.clear();
        for (int i = 0; i < vertexCount; ++i) {
            float f = i;
            float f2 = vertexCount;
            Fisica.parent();
            float angle = PApplet.map((float)f, (float)0.0f, (float)f2, (float)0.0f, (float)((float)Math.PI * 2));
            float vx = x + size / 2.0f * PApplet.sin((float)angle);
            float vy = y + size / 2.0f * PApplet.cos((float)angle);
            this.vertex(vx, vy);
        }
    }

    public void setAsCircle(float x, float y, float size) {
        this.setAsCircle(x, y, size, 30);
    }

    public void setAsCircle(float size) {
        this.setAsCircle(0.0f, 0.0f, size, 30);
    }

    public void setAsCircle(float size, int vertexCount) {
        this.setAsCircle(0.0f, 0.0f, size, vertexCount);
    }

    public float getVertexSize() {
        return Fisica.worldToScreen(this.m_vertexSize);
    }

    public void setVertexSize(float size) {
        this.m_vertexSize = Fisica.screenToWorld(size);
    }

    public ArrayList getVertexBodies() {
        return this.m_vertexBodies;
    }

    public void setFrequency(float frequency) {
        if (this.m_joint != null) {
            this.m_joint.setFrequency(frequency);
        }
        this.m_frequency = frequency;
    }

    @Override
    public void setDamping(float damping) {
        if (this.m_joint != null) {
            this.m_joint.setDamping(damping);
        }
        this.m_damping = damping;
    }

    @Override
    public void addForce(float fx, float fy) {
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).addForce(fx, fy);
        }
        this.m_force.add(Fisica.screenToWorld(fx, fy));
    }

    @Override
    public void addTorque(float t) {
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).addTorque(t);
        }
        this.m_torque += t;
    }

    @Override
    public void setDensity(float d) {
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).setDensity(d);
        }
        this.m_density = d;
    }

    @Override
    public void setFriction(float d) {
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).setFriction(d);
        }
        this.m_friction = d;
    }

    @Override
    public void setRestitution(float d) {
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).setRestitution(d);
        }
        this.m_restitution = d;
    }

    @Override
    public void setBullet(boolean d) {
        for (int i = 0; i < this.m_vertexBodies.size(); ++i) {
            ((FBody)this.m_vertexBodies.get(i)).setBullet(d);
        }
        this.m_bullet = d;
    }

    @Override
    public void setNoStroke() {
        super.setNoStroke();
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void setNoFill() {
        super.setNoFill();
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void setFillColor(int col) {
        super.setFillColor(col);
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void setStrokeColor(int col) {
        super.setStrokeColor(col);
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void setStrokeWeight(float col) {
        super.setStrokeWeight(col);
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void setDrawable(boolean val) {
        super.setDrawable(val);
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void attachImage(PImage img) {
        super.attachImage(img);
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }

    @Override
    public void dettachImage() {
        super.dettachImage();
        if (this.m_joint != null) {
            this.m_joint.updateStyle(this);
        }
    }
}

