/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FContact;
import fisica.FDrawable;
import fisica.FJoint;
import fisica.FWorld;
import fisica.Fisica;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.joints.JointEdge;

public abstract class FBody
extends FDrawable {
    protected float m_density = 1.0f;
    protected float m_restitution = 0.1f;
    protected float m_friction = 0.1f;
    protected boolean m_bullet = false;
    protected boolean m_sensor = false;
    protected boolean m_static = false;
    protected float m_linearDamping = 0.5f;
    protected float m_angularDamping = 0.5f;
    protected boolean m_rotatable = true;
    protected boolean m_allowSleep = true;
    protected boolean m_isSleeping = false;
    protected int m_groupIndex = 0;
    protected int m_filterBits = 65535;
    protected int m_categoryBits = 1;
    protected Vec2 m_linearVelocity = new Vec2(0.0f, 0.0f);
    protected float m_angularVelocity = 0.0f;
    protected Vec2 m_force = new Vec2(0.0f, 0.0f);
    protected float m_torque = 0.0f;
    protected Vec2 m_position = new Vec2(0.0f, 0.0f);
    protected float m_angle = 0.0f;
    protected String m_name;
    protected Body m_body;
    protected FWorld m_world;
    protected FBody m_parent;
    protected boolean m_grabbable = true;
    protected Shape m_shape = null;

    protected void processBody(Body bd, ShapeDef sd) {
        this.m_shape = bd.createShape(sd);
        this.m_shape.m_userData = this;
    }

    public Body getBox2dBody() {
        return this.m_body;
    }

    public int getGroupIndex() {
        return this.m_groupIndex;
    }

    public void addToWorld(FWorld world) {
        BodyDef bd = new BodyDef();
        bd.isBullet = this.m_bullet;
        this.m_world = world;
        this.m_body = world.createBody(bd);
        this.m_body.m_userData = this;
        this.m_body.setXForm(this.m_position, this.m_angle);
        this.m_body.setLinearVelocity(this.m_linearVelocity);
        this.m_body.setAngularVelocity(this.m_angularVelocity);
        this.m_body.m_linearDamping = this.m_linearDamping;
        this.m_body.m_angularDamping = this.m_angularDamping;
        this.m_body.m_flags = this.m_rotatable ? (this.m_body.m_flags &= 0xFFFFFFBF) : (this.m_body.m_flags |= 0x40);
        this.m_body.m_flags = this.m_allowSleep ? (this.m_body.m_flags |= 0x10) : (this.m_body.m_flags &= 0xFFFFFFEF);
        this.m_body.setBullet(this.m_bullet);
        this.m_body.applyForce(this.m_force, this.m_body.getWorldCenter());
        this.m_body.applyTorque(this.m_torque);
        this.m_body.m_type = this.m_static ? 0 : 1;
        ShapeDef sd = this.getProcessedShapeDef();
        if (sd != null) {
            this.processBody(this.m_body, sd);
        }
        ArrayList bodies = this.getBodies();
        ArrayList sds = this.getShapeDefs();
        if (sds.size() != bodies.size()) {
            for (int i = 0; i < sds.size(); ++i) {
                sd = (ShapeDef)sds.get(i);
                if (sd == null) continue;
                this.processBody(this.m_body, sd);
            }
        } else {
            for (int i = 0; i < sds.size(); ++i) {
                FBody b = (FBody)bodies.get(i);
                sd = (ShapeDef)sds.get(i);
                if (sd == null) continue;
                b.processBody(this.m_body, sd);
            }
        }
        this.updateMass();
    }

    public void setState(FBody b) {
        if (b == null || b.m_body == null) {
            return;
        }
        this.m_linearVelocity = b.m_body.getLinearVelocity();
        this.m_angularVelocity = b.m_body.getAngularVelocity();
        this.m_position = b.m_body.getMemberXForm().position;
        this.m_angle = b.m_body.getAngle();
        this.m_force = b.m_body.m_force;
        this.m_torque = b.m_body.m_torque;
    }

    public void setStateFromWorld() {
        if (this.m_body == null) {
            return;
        }
        this.m_linearVelocity = this.m_body.getLinearVelocity();
        this.m_angularVelocity = this.m_body.getAngularVelocity();
        this.m_position = this.m_body.getMemberXForm().position;
        this.m_angle = this.m_body.getAngle();
        this.m_force = this.m_body.m_force;
        this.m_torque = this.m_body.m_torque;
    }

    public void recreateInWorld() {
        if (this.m_body == null) {
            return;
        }
        this.setStateFromWorld();
        this.m_world.remove(this);
        this.m_world.add(this);
    }

    public void removeFromWorld() {
        if (this.m_body == null) {
            return;
        }
        this.m_world.destroyBody(this.m_body);
        this.m_body = null;
        this.m_world = null;
    }

    protected ShapeDef getShapeDef() {
        return null;
    }

    protected ShapeDef getTransformedShapeDef() {
        return this.getShapeDef();
    }

    protected ShapeDef getProcessedShapeDef() {
        ShapeDef sd = this.getShapeDef();
        if (sd != null) {
            sd.isSensor = this.m_sensor;
            sd.filter.groupIndex = this.m_groupIndex;
            sd.filter.maskBits = this.m_filterBits;
            sd.filter.categoryBits = this.m_categoryBits;
        }
        return sd;
    }

    protected ArrayList getShapeDefs() {
        return new ArrayList();
    }

    protected ArrayList getBodies() {
        return new ArrayList();
    }

    protected ShapeDef processShapeDef(ShapeDef sd) {
        if (sd != null) {
            sd.isSensor = this.m_sensor;
            sd.filter.groupIndex = this.m_groupIndex;
            sd.filter.maskBits = this.m_filterBits;
            sd.filter.categoryBits = this.m_categoryBits;
        }
        return sd;
    }

    protected void preDraw(PGraphics applet) {
        applet.pushStyle();
        applet.pushMatrix();
        this.applyMatrix(applet);
        applet.ellipseMode(3);
        applet.rectMode(3);
        this.appletFillStroke(applet);
    }

    protected void postDraw(PGraphics applet) {
        applet.popMatrix();
        applet.popStyle();
    }

    protected void preDrawDebug(PGraphics applet) {
        applet.pushStyle();
        applet.pushMatrix();
        this.applyMatrix(applet);
        applet.ellipseMode(3);
        applet.rectMode(3);
        applet.strokeWeight(1.0f);
        if (this.m_body != null) {
            applet.fill(0.0f, 200.0f, 0.0f, 50.0f);
            applet.stroke(0.0f, 200.0f, 0.0f, 150.0f);
        }
        if (this.isSleeping()) {
            applet.fill(200.0f, 0.0f, 0.0f, 50.0f);
            applet.stroke(200.0f, 0.0f, 0.0f, 150.0f);
        }
        if (this.isStatic()) {
            applet.fill(0.0f, 0.0f, 200.0f, 50.0f);
            applet.stroke(0.0f, 0.0f, 200.0f, 150.0f);
        }
        if (this.isSensor()) {
            applet.noStroke();
        }
    }

    protected void postDrawDebug(PGraphics applet) {
        if (this.m_body != null) {
            applet.fill(0.0f, 200.0f, 0.0f, 150.0f);
        }
        if (this.isSleeping()) {
            applet.fill(200.0f, 0.0f, 0.0f, 150.0f);
        }
        if (this.isStatic()) {
            applet.fill(0.0f, 0.0f, 200.0f, 150.0f);
        }
        applet.line(-3.0f, 0.0f, 3.0f, 0.0f);
        applet.line(0.0f, -3.0f, 0.0f, 3.0f);
        applet.popMatrix();
        if (this.getBox2dBody() != null) {
            applet.pushStyle();
            applet.stroke(120, 40.0f);
            applet.noFill();
            applet.rectMode(1);
            AABB aabb = this.getAABB();
            Vec2 lower = Fisica.worldToScreen(aabb.lowerBound);
            Vec2 upper = Fisica.worldToScreen(aabb.upperBound);
            applet.rect(lower.x, lower.y, upper.x, upper.y);
            applet.popStyle();
            applet.pushMatrix();
            Vec2 cent = Fisica.worldToScreen(this.getBox2dBody().getWorldCenter());
            applet.translate(cent.x, cent.y);
            applet.pushStyle();
            applet.noStroke();
            applet.rect(0.0f, 0.0f, 3.0f, 3.0f);
            applet.popStyle();
            applet.popMatrix();
            String infobox = "";
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(1);
            AABB bb = this.getBB();
            Vec2 dim = new Vec2(bb.upperBound);
            dim = dim.sub(bb.lowerBound);
            float width = dim.x;
            float height = dim.y;
            infobox = infobox + "w: ";
            infobox = (double)width <= 0.001 ? infobox + df.format((double)width * 100.0) + "cm" : infobox + df.format(width) + "m";
            infobox = infobox + "\n";
            infobox = infobox + "h: ";
            infobox = (double)height <= 0.001 ? infobox + df.format((double)height * 100.0) + "cm" : infobox + df.format(height) + "m";
            infobox = infobox + "\n";
            if (!this.isStatic()) {
                float m = this.getMass();
                infobox = m <= 1000.0f ? infobox + "m: " + df.format(this.getMass()) + "g\n" : infobox + "m: " + df.format((double)this.getMass() / 1000.0) + "Kg\n";
            }
            applet.text(infobox, upper.x + 4.0f, lower.y - 4.0f);
        }
        applet.popStyle();
    }

    protected AABB getAABB() {
        AABB result = new AABB();
        boolean first = true;
        Body b = this.getBox2dBody();
        if (b == null) {
            return result;
        }
        AABB temp = new AABB();
        XForm tempXForm = b.getXForm();
        if (b != null) {
            for (Shape ss = b.getShapeList(); ss != null; ss = ss.getNext()) {
                ss.computeAABB(temp, tempXForm);
                if (first) {
                    result = new AABB(temp);
                    first = false;
                    continue;
                }
                result = new AABB(Vec2.min((Vec2)result.lowerBound, (Vec2)temp.lowerBound), Vec2.max((Vec2)result.upperBound, (Vec2)temp.upperBound));
            }
        }
        return result;
    }

    protected AABB getBB() {
        AABB result = new AABB();
        boolean first = true;
        Body b = this.getBox2dBody();
        if (b == null) {
            return result;
        }
        AABB temp = new AABB();
        XForm tempXForm = b.getXForm();
        tempXForm.setIdentity();
        if (b != null) {
            for (Shape ss = b.getShapeList(); ss != null; ss = ss.getNext()) {
                ss.computeAABB(temp, tempXForm);
                if (first) {
                    result = new AABB(temp);
                    first = false;
                    continue;
                }
                result = new AABB(Vec2.min((Vec2)result.lowerBound, (Vec2)temp.lowerBound), Vec2.max((Vec2)result.upperBound, (Vec2)temp.upperBound));
            }
        }
        return result;
    }

    protected void applyMatrix(PGraphics applet) {
        applet.translate(this.getX(), this.getY());
        applet.rotate(this.getRotation());
    }

    public void setGroupIndex(int index) {
        this.m_groupIndex = index;
        this.recreateInWorld();
    }

    public void setFilterBits(int mask) {
        this.m_filterBits = mask;
        this.recreateInWorld();
    }

    public void setCategoryBits(int mask) {
        this.m_categoryBits = mask;
        this.recreateInWorld();
    }

    public int getCategoryBits() {
        return this.m_categoryBits;
    }

    public int getFilterBits() {
        return this.m_filterBits;
    }

    public void setParent(FBody b) {
        this.m_parent = b;
    }

    public FBody getParent() {
        return this.m_parent;
    }

    public void setGrabbable(boolean value) {
        this.m_grabbable = value;
    }

    public void setForce(float fx, float fy) {
        this.resetForces();
        this.addForce(Fisica.screenToWorld(fx), Fisica.screenToWorld(fy));
    }

    public float getForceX() {
        return Fisica.worldToScreen((Vec2)this.m_force).x;
    }

    public float getForceY() {
        return Fisica.worldToScreen((Vec2)this.m_force).y;
    }

    public void addTorque(float torque) {
        if (this.m_body != null) {
            this.m_body.applyTorque(torque);
        }
        this.m_torque += torque;
    }

    public void addForce(float fx, float fy) {
        if (this.m_body != null) {
            this.m_body.applyForce(Fisica.screenToWorld(fx, fy), this.m_body.getWorldCenter());
        }
        this.m_force.x += Fisica.screenToWorld(fx);
        this.m_force.y += Fisica.screenToWorld(fy);
    }

    public void addImpulse(float fx, float fy) {
        if (this.m_body != null) {
            this.m_body.applyImpulse(Fisica.screenToWorld(fx, fy), this.m_body.getWorldCenter());
        }
        this.m_force.x += Fisica.screenToWorld(fx);
        this.m_force.y += Fisica.screenToWorld(fy);
    }

    public void addForce(float fx, float fy, float px, float py) {
        if (this.m_body != null) {
            this.m_body.applyForce(Fisica.screenToWorld(fx, fy), this.m_body.getWorldCenter().add(Fisica.screenToWorld(px, py)));
        }
    }

    public void addImpulse(float fx, float fy, float px, float py) {
        if (this.m_body != null) {
            this.m_body.applyImpulse(Fisica.screenToWorld(fx, fy), this.m_body.getWorldCenter().add(Fisica.screenToWorld(px, py)));
        }
    }

    public void resetForces() {
        if (this.m_body != null) {
            this.m_body.m_force.setZero();
            this.m_body.m_torque = 0.0f;
        }
        this.m_force.setZero();
        this.m_torque = 0.0f;
    }

    public float getVelocityX() {
        if (this.m_body != null) {
            return Fisica.worldToScreen((Vec2)this.m_body.getLinearVelocity()).x;
        }
        return Fisica.worldToScreen((Vec2)this.m_linearVelocity).x;
    }

    public float getVelocityY() {
        if (this.m_body != null) {
            return Fisica.worldToScreen((Vec2)this.m_body.getLinearVelocity()).y;
        }
        return Fisica.worldToScreen((Vec2)this.m_linearVelocity).y;
    }

    public void setVelocity(float vx, float vy) {
        if (this.m_body != null) {
            this.m_body.setLinearVelocity(Fisica.screenToWorld(vx, vy));
            this.m_body.wakeUp();
        }
        this.m_linearVelocity = Fisica.screenToWorld(vx, vy);
    }

    public void adjustVelocity(float dvx, float dvy) {
        if (this.m_body != null) {
            this.m_body.setLinearVelocity(Fisica.screenToWorld(this.getVelocityX() + dvx, this.getVelocityY() + dvy));
            this.m_body.wakeUp();
        }
        this.m_linearVelocity = Fisica.screenToWorld(this.getVelocityX() + dvx, this.getVelocityY() + dvy);
    }

    public float getX() {
        if (this.m_body != null) {
            return Fisica.worldToScreen((Vec2)this.m_body.getMemberXForm().position).x;
        }
        return Fisica.worldToScreen((Vec2)this.m_position).x;
    }

    public float getY() {
        if (this.m_body != null) {
            return Fisica.worldToScreen((Vec2)this.m_body.getMemberXForm().position).y;
        }
        return Fisica.worldToScreen((Vec2)this.m_position).y;
    }

    public void setPosition(float x, float y) {
        if (this.m_body != null) {
            this.m_body.setXForm(Fisica.screenToWorld(x, y), this.m_body.getAngle());
        }
        this.m_position = Fisica.screenToWorld(x, y);
    }

    protected void setPosition(Vec2 position) {
        if (this.m_body != null) {
            this.m_body.setXForm(position, this.m_body.getAngle());
        }
        this.m_position = Fisica.screenToWorld(position);
    }

    public void adjustPosition(float dx, float dy) {
        if (this.m_body != null) {
            this.m_body.setXForm(Fisica.screenToWorld(this.getX() + dx, this.getY() + dy), this.m_body.getAngle());
        }
        this.m_position = Fisica.screenToWorld(this.getX() + dx, this.getY() + dy);
    }

    public float getRotation() {
        if (this.m_body != null) {
            return this.m_body.getAngle();
        }
        return this.m_angle;
    }

    public void setRotation(float w) {
        if (this.m_body != null) {
            this.m_body.setXForm(this.m_body.getMemberXForm().position, w);
        }
        this.m_angle = w;
    }

    public void adjustRotation(float dw) {
        if (this.m_body != null) {
            this.m_body.setXForm(this.m_body.getMemberXForm().position, this.m_body.getAngle() + dw);
        }
        this.m_angle += dw;
    }

    public boolean isResting() {
        return this.isSleeping();
    }

    public boolean isSleeping() {
        if (this.m_body != null) {
            return this.m_body.isSleeping();
        }
        return this.m_isSleeping;
    }

    public void wakeUp() {
        if (this.m_body == null) {
            return;
        }
        this.m_body.wakeUp();
    }

    public float getAngularVelocity() {
        if (this.m_body != null) {
            return this.m_body.getAngularVelocity();
        }
        return this.m_angularVelocity;
    }

    public void setAngularVelocity(float w) {
        if (this.m_body != null) {
            this.m_body.setAngularVelocity(w);
            this.m_body.wakeUp();
        }
        this.m_angularVelocity = w;
    }

    public void adjustAngularVelocity(float dw) {
        if (this.m_body != null) {
            this.m_body.setAngularVelocity(this.m_body.getAngularVelocity() + dw);
            this.m_body.wakeUp();
        }
        this.m_angularVelocity += dw;
    }

    public void setAngularDamping(float damping) {
        if (this.m_body != null) {
            this.m_body.m_angularDamping = damping;
        }
        this.m_angularDamping = damping;
    }

    public void setDamping(float damping) {
        if (this.m_body != null) {
            this.m_body.m_linearDamping = damping;
        }
        this.m_linearDamping = damping;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDensity(float density) {
        this.m_density = density;
        this.updateMass();
    }

    public float getDensity() {
        return this.m_density;
    }

    protected void updateMass() {
        if (this.m_body == null) {
            return;
        }
        Shape s = this.m_body.getShapeList();
        while (s != null) {
            s.m_density = this.m_static ? 0.0f : this.m_density;
            s = s.m_next;
        }
        this.m_body.setMassFromShapes();
    }

    public void setSensor(boolean value) {
        if (this.m_body != null) {
            Shape s = this.m_body.getShapeList();
            while (s != null) {
                s.m_isSensor = value;
                s = s.m_next;
            }
        }
        this.m_sensor = value;
    }

    public boolean isSensor() {
        return this.m_sensor;
    }

    public void setStaticBody(boolean value) {
        this.setStatic(value);
    }

    public void setStatic(boolean value) {
        if (this.m_body != null) {
            this.m_body.m_type = value ? 0 : 1;
        }
        this.m_static = value;
        this.updateMass();
    }

    public float getMass() {
        if (this.m_body != null) {
            return this.m_body.getMass();
        }
        return 0.0f;
    }

    public boolean isStatic() {
        if (this.m_body != null) {
            return this.m_body.isStatic();
        }
        return this.m_static;
    }

    public void setBullet(boolean value) {
        if (this.m_body != null) {
            this.m_body.setBullet(value);
        }
        this.m_bullet = value;
    }

    public void setRestitution(float restitution) {
        if (this.m_body != null) {
            Shape s = this.m_body.getShapeList();
            while (s != null) {
                s.setRestitution(restitution);
                s = s.m_next;
            }
        }
        this.m_restitution = restitution;
    }

    public void setFriction(float friction) {
        if (this.m_body != null) {
            Shape s = this.m_body.getShapeList();
            while (s != null) {
                s.setFriction(friction);
                s = s.m_next;
            }
        }
        this.m_friction = friction;
    }

    public void setRotatable(boolean rotatable) {
        if (this.m_body != null) {
            this.m_body.m_flags = rotatable ? (this.m_body.m_flags &= 0xFFFFFFBF) : (this.m_body.m_flags |= 0x40);
        }
        this.m_rotatable = rotatable;
    }

    public void setAllowSleeping(boolean allowSleep) {
        if (this.m_body != null) {
            if (allowSleep) {
                this.m_body.m_flags |= 0x10;
            } else {
                this.m_body.m_flags &= 0xFFFFFFEF;
                this.m_body.wakeUp();
            }
        }
        this.m_allowSleep = allowSleep;
    }

    public ArrayList getTouching() {
        ArrayList<FBody> result = new ArrayList<FBody>();
        if (this.m_world == null) {
            return result;
        }
        Collection contacts = this.m_world.m_contacts.values();
        for (FContact contact : contacts) {
            if (this == contact.getBody1()) {
                result.add(contact.getBody2());
                continue;
            }
            if (this != contact.getBody2()) continue;
            result.add(contact.getBody1());
        }
        return result;
    }

    public ArrayList getContacts() {
        ArrayList<FContact> result = new ArrayList<FContact>();
        if (this.m_world == null) {
            return result;
        }
        Collection contacts = this.m_world.m_contacts.values();
        for (FContact contact : contacts) {
            if (this != contact.getBody1() && this != contact.getBody2()) continue;
            result.add(contact);
        }
        return result;
    }

    public ArrayList getJoints() {
        ArrayList<FJoint> result = new ArrayList<FJoint>();
        if (this.m_body != null) {
            JointEdge jn = this.m_body.getJointList();
            while (jn != null) {
                FJoint j = (FJoint)jn.joint.m_userData;
                if (j != null) {
                    result.add(j);
                }
                jn = jn.next;
            }
        }
        return result;
    }

    public boolean isConnected(FBody other) {
        if (this.m_body != null) {
            JointEdge jn = this.m_body.getJointList();
            while (jn != null) {
                FBody b = (FBody)jn.other.m_userData;
                if (jn.other.m_userData == other) {
                    return !jn.joint.m_collideConnected;
                }
                jn = jn.next;
            }
        }
        return false;
    }

    public boolean isTouchingBody(FBody b) {
        return this.getTouching().contains(b);
    }

    protected Vec2 getLocalWorldPoint(Vec2 p) {
        if (this.m_body != null) {
            Vec2 v = this.m_body.getLocalPoint(p);
            return v;
        }
        XForm xf = new XForm();
        xf.position.set(Fisica.screenToWorld(this.getX(), this.getY()));
        xf.R.set(this.getRotation());
        return XForm.mulTrans((XForm)xf, (Vec2)p);
    }
}

