/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.Fisica;
import org.jbox2d.collision.shapes.PolygonDef;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class FBox
extends FBody {
    protected float m_height;
    protected float m_width;

    @Override
    protected ShapeDef getShapeDef() {
        PolygonDef pd = new PolygonDef();
        pd.setAsBox(this.m_width / 2.0f, this.m_height / 2.0f);
        pd.density = this.m_density;
        pd.friction = this.m_friction;
        pd.restitution = this.m_restitution;
        pd.isSensor = this.m_sensor;
        return pd;
    }

    @Override
    protected ShapeDef getTransformedShapeDef() {
        PolygonDef pd = (PolygonDef)this.getShapeDef();
        XForm xf = new XForm();
        xf.R.set(-this.m_angle);
        xf.position = Mat22.mul((Mat22)xf.R, (Vec2)this.m_position.negate());
        for (int i = 0; i < pd.vertices.size(); ++i) {
            Vec2 ver = (Vec2)pd.vertices.get(i);
            XForm.mulTransToOut((XForm)xf, (Vec2)ver, (Vec2)ver);
        }
        return pd;
    }

    public FBox(float width, float height) {
        this.m_height = Fisica.screenToWorld(height);
        this.m_width = Fisica.screenToWorld(width);
    }

    public float getHeight() {
        return Fisica.worldToScreen(this.m_height);
    }

    public float getWidth() {
        return Fisica.worldToScreen(this.m_width);
    }

    public void setHeight(float height) {
        this.m_height = Fisica.screenToWorld(height);
        this.recreateInWorld();
    }

    public void setWidth(float width) {
        this.m_width = Fisica.screenToWorld(width);
        this.recreateInWorld();
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        if (this.m_image != null) {
            this.drawImage(applet);
        } else {
            applet.rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        applet.rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        this.postDrawDebug(applet);
    }
}

