/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.FDrawable;
import fisica.FWorld;
import fisica.Fisica;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;

public abstract class FJoint
extends FDrawable {
    protected Joint m_joint;
    protected FWorld m_world;
    protected boolean m_collideConnected = true;

    public Joint getBox2dJoint() {
        return this.m_joint;
    }

    protected void processJoint(World world, JointDef jd) {
        jd.collideConnected = this.m_collideConnected;
        this.m_joint = world.createJoint(jd);
    }

    public void addToWorld(FWorld world) {
        this.m_world = world;
        JointDef jd = this.getJointDef(world);
        if (jd == null) {
            return;
        }
        this.processJoint(this.m_world, jd);
        this.m_joint.m_userData = this;
    }

    public void removeFromWorld() {
        if (this.m_joint == null) {
            return;
        }
        this.m_world.destroyJoint(this.m_joint);
        this.m_joint = null;
        this.m_world = null;
    }

    protected JointDef getJointDef(FWorld world) {
        return null;
    }

    protected void preDraw(PGraphics applet) {
        applet.pushStyle();
        applet.pushMatrix();
        applet.ellipseMode(3);
        applet.rectMode(3);
        this.appletFillStroke(applet);
    }

    protected void postDraw(PGraphics applet) {
        applet.popMatrix();
        applet.popStyle();
    }

    protected void preDrawDebug(PGraphics applet) {
        applet.pushStyle();
        applet.pushMatrix();
        applet.ellipseMode(3);
        applet.rectMode(3);
        applet.strokeWeight(1.0f);
        applet.fill(80, 50.0f);
        applet.stroke(80, 150.0f);
    }

    protected void postDrawDebug(PGraphics applet) {
        applet.popMatrix();
        applet.popStyle();
    }

    public FBody getBody1() {
        if (this.m_joint != null) {
            return (FBody)this.m_joint.m_body1.getUserData();
        }
        return null;
    }

    public FBody getBody2() {
        if (this.m_joint != null) {
            return (FBody)this.m_joint.m_body2.getUserData();
        }
        return null;
    }

    public void setCollideConnected(boolean value) {
        if (this.m_joint != null) {
            this.m_joint.m_collideConnected = value;
        }
        this.m_collideConnected = value;
    }

    public float getReactionForceX() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getReactionForce()).x;
        }
        return 0.0f;
    }

    public float getReactionForceY() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getReactionForce()).y;
        }
        return 0.0f;
    }

    public float getReactionTorque() {
        if (this.m_joint != null) {
            return this.m_joint.getReactionTorque();
        }
        return 0.0f;
    }
}

