/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.Fisica;
import org.jbox2d.collision.shapes.EdgeChainDef;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.common.Vec2;

public class FLine
extends FBody {
    protected Vec2 m_start;
    protected Vec2 m_end;

    @Override
    protected ShapeDef getShapeDef() {
        EdgeChainDef pd = new EdgeChainDef();
        pd.addVertex(this.m_start);
        pd.addVertex(this.m_end);
        pd.setIsLoop(false);
        pd.density = this.m_density;
        pd.friction = this.m_friction;
        pd.restitution = this.m_restitution;
        pd.isSensor = this.m_sensor;
        return pd;
    }

    public FLine(float x1, float y1, float x2, float y2) {
        this.m_start = Fisica.screenToWorld(x1, y1);
        this.m_end = Fisica.screenToWorld(x2, y2);
    }

    public void setStart(float x, float y) {
        this.m_start = Fisica.screenToWorld(x, y);
        this.recreateInWorld();
    }

    public void setEnd(float x, float y) {
        this.m_end = Fisica.screenToWorld(x, y);
        this.recreateInWorld();
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        if (this.m_image != null) {
            this.drawImage(applet);
        } else {
            Vec2 tempStart = Fisica.worldToScreen(this.m_start);
            Vec2 tempEnd = Fisica.worldToScreen(this.m_end);
            applet.line(tempStart.x, tempStart.y, tempEnd.x, tempEnd.y);
        }
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        Vec2 tempStart = Fisica.worldToScreen(this.m_start);
        Vec2 tempEnd = Fisica.worldToScreen(this.m_end);
        applet.line(tempStart.x, tempStart.y, tempEnd.x, tempEnd.y);
        this.postDrawDebug(applet);
    }
}

