/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PGraphics;
import fisica.FBody;
import fisica.FJoint;
import fisica.FWorld;
import fisica.Fisica;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;

public class FRevoluteJoint
extends FJoint {
    protected FBody m_body1;
    protected FBody m_body2;
    protected Vec2 m_anchor;
    protected Vec2 m_localAnchor1 = new Vec2(0.0f, 0.0f);
    protected Vec2 m_localAnchor2 = new Vec2(0.0f, 0.0f);
    protected float m_referenceAngle = 0.0f;
    protected boolean m_enableLimit = false;
    protected float m_lowerAngle = 0.0f;
    protected float m_upperAngle = 0.0f;
    protected boolean m_enableMotor = false;
    protected float m_motorSpeed = 0.0f;
    protected float m_maxMotorTorque = 0.0f;

    protected void updateLocalAnchors() {
        this.m_localAnchor1 = this.m_body1.getLocalWorldPoint(Fisica.screenToWorld(this.getAnchorX(), this.getAnchorY()));
        this.m_localAnchor2 = this.m_body2.getLocalWorldPoint(Fisica.screenToWorld(this.getAnchorX(), this.getAnchorY()));
    }

    @Override
    protected JointDef getJointDef(FWorld world) {
        RevoluteJointDef md = new RevoluteJointDef();
        md.body1 = this.m_body1.m_body;
        md.body2 = this.m_body2.m_body;
        md.localAnchor1 = this.m_localAnchor1.clone();
        md.localAnchor2 = this.m_localAnchor2.clone();
        md.referenceAngle = this.m_referenceAngle;
        md.lowerAngle = this.m_lowerAngle;
        md.upperAngle = this.m_upperAngle;
        md.enableMotor = this.m_enableMotor;
        md.enableLimit = this.m_enableLimit;
        md.motorSpeed = this.m_motorSpeed;
        md.maxMotorTorque = this.m_maxMotorTorque;
        if (this.m_body1.m_body != null) {
            this.m_body1.m_body.wakeUp();
        }
        if (this.m_body2.m_body != null) {
            this.m_body2.m_body.wakeUp();
        }
        return md;
    }

    public FRevoluteJoint(FBody body1, FBody body2, float x, float y) {
        this.m_body1 = body1;
        this.m_body2 = body2;
        this.m_anchor = Fisica.screenToWorld(x, y);
        this.updateLocalAnchors();
        this.m_referenceAngle = this.m_body2.getRotation() - this.m_body1.getRotation();
    }

    public FRevoluteJoint(FBody body1, FBody body2) {
        this(body1, body2, (body1.getX() + body2.getX()) / 2.0f, (body1.getY() + body2.getY()) / 2.0f);
    }

    public void setLowerAngle(float a) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).m_lowerAngle = a;
        }
        this.m_lowerAngle = a;
    }

    public void setUpperAngle(float a) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).m_upperAngle = a;
        }
        this.m_upperAngle = a;
    }

    public void setEnableLimit(boolean value) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).m_enableLimit = value;
        }
        this.m_enableLimit = value;
    }

    public void setMotorSpeed(float a) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).m_motorSpeed = a;
        }
        this.m_motorSpeed = a;
    }

    public void setMaxMotorTorque(float a) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).m_maxMotorTorque = a;
        }
        this.m_maxMotorTorque = a;
    }

    public void setEnableMotor(boolean value) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).m_enableMotor = value;
        }
        this.m_enableMotor = value;
    }

    public void setAnchor(float x, float y) {
        if (this.m_joint != null) {
            ((RevoluteJoint)this.m_joint).getAnchor2().set(Fisica.screenToWorld(x), Fisica.screenToWorld(y));
        }
        this.m_anchor = Fisica.screenToWorld(x, y);
        this.updateLocalAnchors();
    }

    public float getAnchorX() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor2()).x;
        }
        return Fisica.worldToScreen(this.m_anchor.x);
    }

    public float getAnchorY() {
        if (this.m_joint != null) {
            return Fisica.worldToScreen((Vec2)this.m_joint.getAnchor2()).y;
        }
        return Fisica.worldToScreen(this.m_anchor.y);
    }

    public void setReferenceAngle(float ang) {
        this.m_referenceAngle = ang;
    }

    @Override
    public void draw(PGraphics applet) {
        this.preDraw(applet);
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody1().getX(), this.getBody1().getY());
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody2().getX(), this.getBody2().getY());
        applet.ellipse(this.getAnchorX(), this.getAnchorY(), 10.0f, 10.0f);
        this.postDraw(applet);
    }

    @Override
    public void drawDebug(PGraphics applet) {
        this.preDrawDebug(applet);
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody1().getX(), this.getBody1().getY());
        applet.line(this.getAnchorX(), this.getAnchorY(), this.getBody2().getX(), this.getBody2().getY());
        applet.ellipse(this.getAnchorX(), this.getAnchorY(), 10.0f, 10.0f);
        this.postDrawDebug(applet);
    }
}

