/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PApplet;
import def.processing.core.PGraphics;
import def.processing.event.MouseEvent;
import fisica.FAddBodyAction;
import fisica.FAddJointAction;
import fisica.FBody;
import fisica.FBox;
import fisica.FContact;
import fisica.FContactListener;
import fisica.FContactResult;
import fisica.FJoint;
import fisica.FMouseJoint;
import fisica.FRaycastResult;
import fisica.FRemoveBodyAction;
import fisica.FRemoveJointAction;
import fisica.FWorldAction;
import fisica.Fisica;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Consumer;
import jsweet.util.Lang;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.ContactPoint;
import org.jbox2d.dynamics.contacts.ContactResult;
import org.jbox2d.dynamics.joints.Joint;

public class FWorld
extends World {
    public FBox left;
    public FBox right;
    public FBox top;
    public FBox bottom;
    protected float m_topLeftX;
    protected float m_topLeftY;
    protected float m_bottomRightX;
    protected float m_bottomRightY;
    protected float m_edgesFriction = 0.1f;
    protected float m_edgesRestitution = 0.1f;
    protected boolean m_grabbable = true;
    protected float m_grabPositionX = 0.0f;
    protected float m_grabPositionY = 0.0f;
    protected int m_mouseButton = 37;
    protected HashMap m_contacts;
    protected ArrayList m_contactResults;
    protected LinkedList m_actions;
    protected ArrayList m_fbodies = new ArrayList();
    protected FMouseJoint m_mouseJoint = new FMouseJoint(null, 0.0f, 0.0f);
    private Vec2 m_small = new Vec2(0.001f, 0.001f);
    private AABB m_aabb = new AABB();
    private ConcreteContactListener m_contactListener;
    private FContactListener m_clientContactListener;
    private Consumer<FContact> m_contactStartedMethod;
    private Consumer<FContact> m_contactPersistedMethod;
    private Consumer<FContact> m_contactEndedMethod;
    private Consumer<FContactResult> m_contactResultMethod;

    public void addBody(FBody body) {
        if (body == null) {
            return;
        }
        this.m_fbodies.add(body);
        body.addToWorld(this);
    }

    public void removeBody(FBody body) {
        if (body == null) {
            return;
        }
        if (body == this.m_mouseJoint.getGrabbedBody()) {
            this.removeJoint(this.m_mouseJoint);
            this.m_mouseJoint.releaseGrabbedBody();
        }
        this.m_fbodies.remove(body);
        body.removeFromWorld();
    }

    public void addJoint(FJoint joint) {
        if (joint == null) {
            return;
        }
        joint.addToWorld(this);
    }

    public void removeJoint(FJoint joint) {
        if (joint == null) {
            return;
        }
        joint.removeFromWorld();
    }

    public void setContactListener(FContactListener listener) {
        this.m_clientContactListener = listener;
    }

    public void setContactListener(ContactListener listener) {
        super.setContactListener(listener);
    }

    public void grabBody(float x, float y) {
        if (this.m_mouseJoint.getGrabbedBody() != null) {
            return;
        }
        FBody body = this.getBody(x, y, true);
        if (body == null) {
            return;
        }
        if (!body.m_grabbable) {
            return;
        }
        this.m_mouseJoint.setGrabbedBodyAndTarget(body, x, y);
        this.m_mouseJoint.setFrequency(3.0f);
        this.m_mouseJoint.setDamping(0.1f);
        this.addJoint(this.m_mouseJoint);
        this.m_grabPositionX = x - body.getX();
        this.m_grabPositionY = y - body.getY();
    }

    public void dragBody(float x, float y) {
        if (this.m_mouseJoint.getGrabbedBody() == null) {
            return;
        }
        FBody body = this.m_mouseJoint.getGrabbedBody();
        if (body.isStatic()) {
            body.setPosition(x - this.m_grabPositionX, y - this.m_grabPositionY);
        } else {
            this.m_mouseJoint.setTarget(x, y);
        }
    }

    public void releaseBody() {
        if (this.m_mouseJoint.getGrabbedBody() == null) {
            return;
        }
        this.removeJoint(this.m_mouseJoint);
        this.m_mouseJoint.releaseGrabbedBody();
    }

    public void mouseEvent(MouseEvent event) {
        if (event.getAction() == 1 && event.getButton() == this.m_mouseButton) {
            this.grabBody(event.getX(), event.getY());
        }
        if (event.getAction() == 2 && event.getButton() == this.m_mouseButton) {
            this.releaseBody();
        }
        if (event.getAction() == 4) {
            this.dragBody(event.getX(), event.getY());
        }
    }

    public FWorld(float topLeftX, float topLeftY, float bottomRightX, float bottomRightY) {
        super(new AABB(Fisica.screenToWorld(new Vec2(topLeftX, topLeftY)), Fisica.screenToWorld(new Vec2(bottomRightX, bottomRightY))), Fisica.screenToWorld(new Vec2(0.0f, 10.0f)), true);
        this.m_topLeftX = topLeftX;
        this.m_topLeftY = topLeftY;
        this.m_bottomRightX = bottomRightX;
        this.m_bottomRightY = bottomRightY;
        super.setWarmStarting(true);
        super.setPositionCorrection(true);
        super.setContinuousPhysics(true);
        Fisica.parent().registerMethod("mouseEvent", (Object)this);
        this.m_contactStartedMethod = (Consumer)Lang.object((Object)Fisica.parent()).$get("contactStarted");
        this.m_contactPersistedMethod = (Consumer)Lang.object((Object)Fisica.parent()).$get("contactPersisted");
        this.m_contactEndedMethod = (Consumer)Lang.object((Object)Fisica.parent()).$get("contactEnded");
        this.m_contactResultMethod = (Consumer)Lang.object((Object)Fisica.parent()).$get("contactResult");
        this.m_contactListener = new ConcreteContactListener();
        this.m_contactListener.m_world = this;
        this.setContactListener(this.m_contactListener);
        this.m_contacts = new HashMap();
        this.m_contactResults = new ArrayList();
        this.m_actions = new LinkedList();
        this.m_mouseJoint.setDrawable(false);
        this.setGravity(0.0f, 200.0f);
    }

    public FWorld() {
        this(-Fisica.parent().width, -Fisica.parent().height, 2 * Fisica.parent().width, 2 * Fisica.parent().height);
    }

    public FMouseJoint getMouseJoint() {
        return this.m_mouseJoint;
    }

    public void setGrabbable(boolean value) {
        if (this.m_grabbable == value) {
            return;
        }
        this.m_grabbable = value;
        if (this.m_grabbable) {
            Fisica.parent().registerMethod("mouseEvent", (Object)this);
        } else {
            Fisica.parent().unregisterMethod("mouseEvent", (Object)this);
        }
    }

    public void processActions() {
        while (this.m_actions.size() > 0) {
            ((FWorldAction)this.m_actions.poll()).apply(this);
        }
    }

    public void draw(PGraphics graphics) {
        this.processActions();
        for (int i = 0; i < this.m_fbodies.size(); ++i) {
            FBody fb = (FBody)this.m_fbodies.get(i);
            if (fb == null || !fb.isDrawable()) continue;
            fb.draw(graphics);
        }
        Joint j = this.getJointList();
        while (j != null) {
            FJoint fj = (FJoint)j.m_userData;
            if (fj != null && fj.isDrawable()) {
                fj.draw(graphics);
            }
            j = j.m_next;
        }
    }

    public void drawDebug(PGraphics graphics) {
        this.processActions();
        for (int i = 0; i < this.m_fbodies.size(); ++i) {
            FBody fb = (FBody)this.m_fbodies.get(i);
            if (fb == null) continue;
            fb.drawDebug(graphics);
        }
        Joint j = this.getJointList();
        while (j != null) {
            FJoint fj = (FJoint)j.m_userData;
            if (fj != null) {
                fj.drawDebug(graphics);
            }
            j = j.m_next;
        }
    }

    public void draw() {
        this.draw(Fisica.parentGraphics());
    }

    public void drawDebug() {
        this.drawDebug(Fisica.parentGraphics());
    }

    public void add(FBody body) {
        FAddBodyAction action = new FAddBodyAction(body);
        this.m_actions.add(action);
    }

    public void remove(FBody body) {
        FRemoveBodyAction action = new FRemoveBodyAction(body);
        this.m_actions.add(action);
    }

    public void add(FJoint joint) {
        FAddJointAction action = new FAddJointAction(joint);
        this.m_actions.add(action);
    }

    public void remove(FJoint joint) {
        FRemoveJointAction action = new FRemoveJointAction(joint);
        this.m_actions.add(action);
    }

    public void clear() {
        Joint j = this.getJointList();
        while (j != null) {
            FJoint fj = (FJoint)j.m_userData;
            this.remove(fj);
            j = j.m_next;
        }
        Body b = this.getBodyList();
        while (b != null) {
            FBody fb = (FBody)b.m_userData;
            this.remove(fb);
            b = b.m_next;
        }
    }

    public void setEdges(float topLeftX, float topLeftY, float bottomRightX, float bottomRightY, int color) {
        float height = Math.abs(bottomRightY - topLeftY);
        float width = Math.abs(bottomRightX - topLeftX);
        float ymid = (topLeftY + bottomRightY) / 2.0f;
        float xmid = (topLeftX + bottomRightX) / 2.0f;
        this.left = new FBox(20.0f, height);
        this.left.setStaticBody(true);
        this.left.setGrabbable(false);
        this.left.setFillColor(color);
        this.left.setStrokeColor(color);
        this.left.setPosition(topLeftX - 5.0f, ymid);
        this.addBody(this.left);
        this.right = new FBox(20.0f, height);
        this.right.setStaticBody(true);
        this.right.setGrabbable(false);
        this.right.setFillColor(color);
        this.right.setStrokeColor(color);
        this.right.setPosition(bottomRightX + 5.0f, ymid);
        this.addBody(this.right);
        this.top = new FBox(width, 20.0f);
        this.top.setStaticBody(true);
        this.top.setGrabbable(false);
        this.top.setFillColor(color);
        this.top.setStrokeColor(color);
        this.top.setPosition(xmid, topLeftY - 5.0f);
        this.addBody(this.top);
        this.bottom = new FBox(width, 20.0f);
        this.bottom.setStaticBody(true);
        this.bottom.setGrabbable(false);
        this.bottom.setFillColor(color);
        this.bottom.setStrokeColor(color);
        this.bottom.setPosition(xmid, bottomRightY + 5.0f);
        this.addBody(this.bottom);
        this.setEdgesFriction(this.m_edgesFriction);
        this.setEdgesRestitution(this.m_edgesRestitution);
    }

    public void setEdges(float topLeftX, float topLeftY, float bottomRightX, float bottomRightY) {
        this.setEdges(topLeftX, topLeftY, bottomRightX, bottomRightY, Fisica.parent().color(0));
    }

    public void setEdges(PApplet applet, int color) {
        this.setEdges(0.0f, 0.0f, applet.width, applet.height, color);
    }

    public void setEdges(int color) {
        this.setEdges(Fisica.parent(), color);
    }

    public void setEdges() {
        this.setEdges(Fisica.parent(), Fisica.parent().color(0));
    }

    public void setEdgesFriction(float friction) {
        if (this.left != null) {
            this.left.setFriction(friction);
        }
        if (this.right != null) {
            this.right.setFriction(friction);
        }
        if (this.top != null) {
            this.top.setFriction(friction);
        }
        if (this.bottom != null) {
            this.bottom.setFriction(friction);
        }
        this.m_edgesFriction = friction;
    }

    public void setEdgesRestitution(float restitution) {
        if (this.left != null) {
            this.left.setRestitution(restitution);
        }
        if (this.right != null) {
            this.right.setRestitution(restitution);
        }
        if (this.top != null) {
            this.top.setRestitution(restitution);
        }
        if (this.bottom != null) {
            this.bottom.setRestitution(restitution);
        }
        this.m_edgesRestitution = restitution;
    }

    public void setGravity(float gx, float gy) {
        this.setGravity(Fisica.screenToWorld(new Vec2(gx, gy)));
    }

    public void setGravity(Vec2 vector) {
        super.setGravity(vector);
    }

    public void step() {
        this.step(0.016666668f);
    }

    public void step(float dt) {
        this.step(dt, 10);
    }

    public void step(float dt, int iterationCount) {
        this.processActions();
        this.m_contactResults.clear();
        super.step(dt, iterationCount);
    }

    public FBody getBody(float x, float y) {
        return this.getBody(x, y, true);
    }

    public FBody getBody(float x, float y, boolean getStatic) {
        ArrayList bodies = this.getBodies(x, y, getStatic);
        if (bodies.size() == 0) {
            return null;
        }
        return (FBody)bodies.get(0);
    }

    public ArrayList getBodies() {
        ArrayList<FBody> result = new ArrayList<FBody>();
        Body b = this.getBodyList();
        while (b != null) {
            FBody fb = (FBody)b.m_userData;
            if (fb != null) {
                result.add(fb);
            }
            b = b.m_next;
        }
        return result;
    }

    public ArrayList getBodies(float x, float y) {
        return this.getBodies(x, y, true);
    }

    public ArrayList getBodies(float x, float y, boolean getStatic) {
        return this.getBodies(x, y, getStatic, 10);
    }

    public ArrayList getBodies(float x, float y, boolean getStatic, int count) {
        Vec2 p = Fisica.screenToWorld(x, y);
        this.m_aabb.lowerBound.set(p);
        this.m_aabb.lowerBound.subLocal(this.m_small);
        this.m_aabb.upperBound.set(p);
        this.m_aabb.upperBound.addLocal(this.m_small);
        Shape[] shapes = this.query(this.m_aabb, count);
        ArrayList<FBody> result = new ArrayList<FBody>();
        if (shapes == null) {
            return result;
        }
        for (int j = 0; j < shapes.length; ++j) {
            boolean inside;
            Body shapeBody = shapes[j].getBody();
            if (shapeBody.isStatic() && !getStatic || !(inside = shapes[j].testPoint(shapeBody.getMemberXForm(), p))) continue;
            result.add((FBody)shapeBody.getUserData());
        }
        return result;
    }

    public int raycast(float x1, float y1, float x2, float y2, FBody[] bodies, int maxCount, boolean solidShapes) {
        Segment segment = new Segment();
        segment.p1.set(Fisica.screenToWorld(x1, y1));
        segment.p2.set(Fisica.screenToWorld(x2, y2));
        Object[] results = new Object[maxCount];
        Shape[] shapes = new Shape[maxCount];
        int count = this.raycast(segment, shapes, maxCount, solidShapes, null);
        for (int i = 0; i < count; ++i) {
            Shape shape = shapes[i];
            Body shapeBody = shape.getBody();
            results[i] = (FBody)shapeBody.getUserData();
        }
        return count;
    }

    public int raycast(Segment segment, Shape[] shapes, int maxCount, boolean solidShapes, Object userData) {
        return super.raycast(segment, shapes, maxCount, solidShapes, userData);
    }

    public Shape raycastOne(Segment segment, RaycastResult result, boolean solidShapes, Object userData) {
        return super.raycastOne(segment, result, solidShapes, userData);
    }

    public FBody raycastOne(float x1, float y1, float x2, float y2, FRaycastResult result, boolean solidShapes) {
        Segment segment = new Segment();
        segment.p1.set(Fisica.screenToWorld(x1, y1));
        segment.p2.set(Fisica.screenToWorld(x2, y2));
        int maxCount = 1;
        Shape[] shapes = new Shape[maxCount];
        int count = this.raycast(segment, shapes, maxCount, solidShapes, null);
        if (count == 0) {
            return null;
        }
        assert (count == 1);
        RaycastResult temp = new RaycastResult();
        shapes[0].testSegment(shapes[0].getBody().getMemberXForm(), temp, segment, 1.0f);
        result.set(x1, y1, x2, y2, temp);
        return (FBody)shapes[0].getBody().getUserData();
    }

    class ConcreteContactListener
    implements ContactListener {
        public FWorld m_world;

        ConcreteContactListener() {
        }

        public void add(ContactPoint point) {
            FContact contact = new FContact(point);
            this.m_world.m_contacts.put(contact.getId(), contact);
            if (FWorld.this.m_clientContactListener != null) {
                try {
                    FWorld.this.m_clientContactListener.contactStarted(contact);
                    return;
                }
                catch (Exception e) {
                    System.err.println("Disabling contact listener because of an error.");
                    e.printStackTrace();
                    FWorld.this.m_clientContactListener = null;
                }
            }
            if (this.m_world.m_contactStartedMethod == null) {
                return;
            }
            try {
                Lang.function((Consumer)this.m_world.m_contactStartedMethod).apply((Object)Fisica.parent(), (Object)new Object[]{contact});
            }
            catch (Exception e) {
                System.err.println("Disabling contactStarted(ContactPoint point) because of an error.");
                e.printStackTrace();
                this.m_world.m_contactStartedMethod = null;
            }
        }

        public void persist(ContactPoint point) {
            FContact contact = new FContact(point);
            this.m_world.m_contacts.put(contact.getId(), contact);
            if (FWorld.this.m_clientContactListener != null) {
                try {
                    FWorld.this.m_clientContactListener.contactPersisted(contact);
                    return;
                }
                catch (Exception e) {
                    System.err.println("Disabling contact listener because of an error.");
                    e.printStackTrace();
                    FWorld.this.m_clientContactListener = null;
                }
            }
            if (this.m_world.m_contactPersistedMethod == null) {
                return;
            }
            try {
                Lang.function((Consumer)this.m_world.m_contactPersistedMethod).apply((Object)Fisica.parent(), (Object)new Object[]{contact});
            }
            catch (Exception e) {
                System.err.println("Disabling contactPersisted(FContact point) because of an error.");
                e.printStackTrace();
                this.m_world.m_contactPersistedMethod = null;
            }
        }

        public void remove(ContactPoint point) {
            FContact contact = new FContact(point);
            this.m_world.m_contacts.remove(contact.getId());
            if (FWorld.this.m_clientContactListener != null) {
                try {
                    FWorld.this.m_clientContactListener.contactEnded(contact);
                    return;
                }
                catch (Exception e) {
                    System.err.println("Disabling contact listener because of an error.");
                    e.printStackTrace();
                    FWorld.this.m_clientContactListener = null;
                }
            }
            if (this.m_world.m_contactEndedMethod == null) {
                return;
            }
            try {
                Lang.function((Consumer)this.m_world.m_contactEndedMethod).apply((Object)Fisica.parent(), (Object)new Object[]{contact});
            }
            catch (Exception e) {
                System.err.println("Disabling contactEnded(FContact point) because of an error.");
                e.printStackTrace();
                this.m_world.m_contactEndedMethod = null;
            }
        }

        public void result(ContactResult point) {
            FContactResult result = new FContactResult(point);
            FWorld.this.m_contactResults.add(result);
            if (FWorld.this.m_clientContactListener != null) {
                try {
                    FWorld.this.m_clientContactListener.contactResult(result);
                    return;
                }
                catch (Exception e) {
                    System.err.println("Disabling contact listener because of an error.");
                    e.printStackTrace();
                    FWorld.this.m_clientContactListener = null;
                }
            }
            if (this.m_world.m_contactResultMethod == null) {
                return;
            }
            try {
                Lang.function((Consumer)this.m_world.m_contactResultMethod).apply((Object)Fisica.parent(), (Object)new Object[]{result});
            }
            catch (Exception e) {
                System.err.println("Disabling contactResult(FContactResult result) because of an error.");
                e.printStackTrace();
                this.m_world.m_contactResultMethod = null;
            }
        }
    }
}

