/*
 * Decompiled with CFR 0.152.
 */
package fisica;

import def.processing.core.PApplet;
import def.processing.core.PConstants;
import def.processing.core.PGraphics;
import jsweet.util.Lang;
import org.jbox2d.common.Vec2;

public class Fisica
implements PConstants {
    private static boolean m_initialized = false;
    private static PApplet m_parent;
    private static FViewport m_viewport;
    private static PGraphics m_parentGraphics;

    public static Vec2 screenToWorld(Vec2 m_in) {
        return m_viewport.getScreenToWorld(m_in);
    }

    public static Vec2 screenToWorld(float x, float y) {
        return m_viewport.getScreenToWorld(x, y);
    }

    public static float screenToWorld(float a) {
        return m_viewport.getScreenToWorld(a);
    }

    public static Vec2 worldToScreen(Vec2 m_in) {
        return m_viewport.getWorldToScreen(m_in);
    }

    public static Vec2 worldToScreen(float x, float y) {
        return m_viewport.getWorldToScreen(x, y);
    }

    public static float worldToScreen(float a) {
        return m_viewport.getWorldToScreen(a);
    }

    protected static boolean initialized() {
        return m_initialized;
    }

    public static PApplet parent() {
        if (m_parent == null) {
            throw new LibraryNotInitializedException();
        }
        return m_parent;
    }

    public static PGraphics parentGraphics() {
        if (m_parentGraphics == null) {
            throw new LibraryNotInitializedException();
        }
        return m_parentGraphics;
    }

    public static void init(PApplet applet) {
        m_parent = applet;
        m_parentGraphics = (PGraphics)Lang.any((Object)applet);
        m_parentGraphics.beginDraw();
        m_initialized = true;
        m_viewport = new FViewport();
        m_viewport.setScaleTransform(20.0f);
    }

    public static void setScale(float scale) {
        Fisica.m_viewport.m_scale = scale;
    }

    public static class LibraryNotInitializedException
    extends NullPointerException {
        private static final long serialVersionUID = -3710605630786298674L;

        LibraryNotInitializedException() {
            super("Must call Fisica.init(this); before using this library.");
        }
    }

    protected static class FViewport {
        float m_scale = 1.0f;

        public void setScaleTransform(float a) {
            this.m_scale = a;
        }

        public float getScreenToWorld(float a) {
            return a / this.m_scale;
        }

        public Vec2 getScreenToWorld(float x, float y) {
            return new Vec2(x / this.m_scale, y / this.m_scale);
        }

        public Vec2 getScreenToWorld(Vec2 p) {
            return new Vec2(p.x / this.m_scale, p.y / this.m_scale);
        }

        public float getWorldToScreen(float a) {
            return a * this.m_scale;
        }

        public Vec2 getWorldToScreen(float x, float y) {
            return new Vec2(x * this.m_scale, y * this.m_scale);
        }

        public Vec2 getWorldToScreen(Vec2 p) {
            return new Vec2(p.x * this.m_scale, p.y * this.m_scale);
        }
    }
}

