/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.extension.PrinterAdapter;

public class ExtensionManager {
    private static final Logger logger = Logger.getLogger(ExtensionManager.class);
    private File extensionDir;

    public ExtensionManager(String extensionDirPath) {
        this.extensionDir = new File(extensionDirPath);
    }

    public void checkAndCompileExtension(File workingDir, String compileClassPath) {
        boolean change;
        if (!this.extensionDir.exists()) {
            return;
        }
        logger.info((Object)("checking extension (working dir = " + workingDir + ")"));
        this.initExtensionClassPath();
        SourceFile[] sourceFiles = SourceFile.getSourceFiles(this.extensionDir);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-classpath", compileClassPath));
        File extensionDescriptorFile = new File(workingDir, "extension.json");
        Map<String, String> extensionDescriptor = new HashMap();
        try {
            extensionDescriptor = (Map)new Gson().fromJson(FileUtils.readFileToString((File)extensionDescriptorFile), new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<File> filesToCompile = Arrays.asList(SourceFile.toFiles(sourceFiles));
        boolean bl = change = filesToCompile.size() != extensionDescriptor.size();
        if (!change) {
            for (File f : filesToCompile) {
                if (extensionDescriptor.containsKey(f.getPath()) && ((String)extensionDescriptor.get(f.getPath())).equals("" + f.lastModified())) continue;
                change = true;
                break;
            }
        }
        if (change) {
            logger.info((Object)("compiling " + filesToCompile.size() + " extension file(s)"));
            extensionDescriptor.clear();
            for (File f : filesToCompile) {
                extensionDescriptor.put(f.getPath(), "" + f.lastModified());
            }
            try {
                logger.debug((Object)("writing extension descriptor: " + extensionDescriptor));
                FileUtils.deleteQuietly((File)extensionDescriptorFile);
                FileUtils.writeStringToFile((File)extensionDescriptorFile, (String)new Gson().toJson(extensionDescriptor));
                if (!extensionDescriptorFile.exists()) {
                    throw new Exception();
                }
                logger.debug((Object)("created " + extensionDescriptorFile.getAbsolutePath()));
            }
            catch (Exception e) {
                throw new RuntimeException("unable to create extension description file", e);
            }
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(filesToCompile);
            if (!compiler.getTask(null, fileManager, null, optionList, null, compilationUnits1).call().booleanValue()) {
                throw new RuntimeException("JSweet extension compilation failed");
            }
        }
    }

    private void initExtensionClassPath() {
        if (!this.extensionDir.exists()) {
            return;
        }
        try {
            if (!(PrinterAdapter.class.getClassLoader() instanceof URLClassLoader)) {
                throw new RuntimeException("local extensions are not supported in this environment, please use a packaged extension");
            }
            URLClassLoader urlClassLoader = (URLClassLoader)PrinterAdapter.class.getClassLoader();
            Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURLMethod.setAccessible(true);
            boolean foundExtension = false;
            URL[] uRLArray = urlClassLoader.getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                if (url.getPath().endsWith("/jsweet_extension")) {
                    foundExtension = true;
                    break;
                }
                ++n2;
            }
            if (!foundExtension) {
                addURLMethod.invoke((Object)urlClassLoader, this.extensionDir.toURI().toURL());
                logger.debug((Object)("updated classpath with: " + this.extensionDir.toURI().toURL()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("fail to initalize extension classpath", e);
        }
    }
}

