/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model;

import com.sun.tools.javac.tree.JCTree;
import javax.lang.model.element.VariableElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.support.ArrayAccessElementSupport;
import org.jsweet.transpiler.model.support.AssignmentElementSupport;
import org.jsweet.transpiler.model.support.BinaryOperatorElementSupport;
import org.jsweet.transpiler.model.support.CaseElementSupport;
import org.jsweet.transpiler.model.support.CompilationUnitElementSupport;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.model.support.ForeachLoopElementSupport;
import org.jsweet.transpiler.model.support.IdentifierElementSupport;
import org.jsweet.transpiler.model.support.ImportElementSupport;
import org.jsweet.transpiler.model.support.LiteralElementSupport;
import org.jsweet.transpiler.model.support.MethodInvocationElementSupport;
import org.jsweet.transpiler.model.support.NewArrayElementSupport;
import org.jsweet.transpiler.model.support.NewClassElementSupport;
import org.jsweet.transpiler.model.support.UnaryOperatorElementSupport;
import org.jsweet.transpiler.model.support.VariableAccessElementSupport;

public class ExtendedElementFactory {
    public static final ExtendedElementFactory INSTANCE = new ExtendedElementFactory();

    public static <T extends JCTree> T toTree(ExtendedElement element) {
        return ((ExtendedElementSupport)element).getTree();
    }

    public ExtendedElement create(JCTree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getTag()) {
            case APPLY: {
                return new MethodInvocationElementSupport((JCTree.JCMethodInvocation)tree);
            }
            case SELECT: {
                if (((JCTree.JCFieldAccess)tree).sym instanceof VariableElement) {
                    return new VariableAccessElementSupport(tree);
                }
                return new ExtendedElementSupport<JCTree>(tree);
            }
            case NEWCLASS: {
                return new NewClassElementSupport((JCTree.JCNewClass)tree);
            }
            case IDENT: {
                if (((JCTree.JCIdent)tree).sym instanceof VariableElement) {
                    return new VariableAccessElementSupport(tree);
                }
                return new IdentifierElementSupport((JCTree.JCIdent)tree);
            }
            case LITERAL: {
                return new LiteralElementSupport((JCTree.JCLiteral)tree);
            }
            case CASE: {
                return new CaseElementSupport((JCTree.JCCase)tree);
            }
            case NEWARRAY: {
                return new NewArrayElementSupport((JCTree.JCNewArray)tree);
            }
            case INDEXED: {
                return new ArrayAccessElementSupport((JCTree.JCArrayAccess)tree);
            }
            case FOREACHLOOP: {
                return new ForeachLoopElementSupport((JCTree.JCEnhancedForLoop)tree);
            }
            case ASSIGN: {
                return new AssignmentElementSupport((JCTree.JCAssign)tree);
            }
            case IMPORT: {
                return new ImportElementSupport((JCTree.JCImport)tree);
            }
            case TOPLEVEL: {
                return new CompilationUnitElementSupport((JCTree.JCCompilationUnit)tree);
            }
            case OR: 
            case AND: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return new BinaryOperatorElementSupport((JCTree.JCBinary)tree);
            }
            case POS: 
            case NEG: 
            case NOT: 
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: {
                return new UnaryOperatorElementSupport((JCTree.JCUnary)tree);
            }
        }
        return new ExtendedElementSupport<JCTree>(tree);
    }
}

