/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.eval;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.jsweet.transpiler.eval.EvalOptions;
import org.jsweet.transpiler.eval.RuntimeEval;
import org.jsweet.transpiler.eval.TraceBasedEvaluationResult;
import org.jsweet.transpiler.util.EvaluationResult;
import org.jsweet.transpiler.util.ProcessUtil;

public class JavaScriptEval
extends RuntimeEval {
    private static final String PHANTOMJS_EXECUTABLE_NAME = "phantomjs";
    private static final String PHANTOMJS_PACKAGE_NAME = "phantomjs-prebuilt";
    private EvalOptions options;
    private JavaScriptRuntime runtime;

    public JavaScriptEval(EvalOptions options, JavaScriptRuntime runtime) {
        this.options = options;
        this.runtime = runtime;
    }

    public EvaluationResult performEval(Collection<File> jsFiles) throws Exception {
        Process runProcess;
        StringWriter trace = new StringWriter();
        if (this.options.useModules) {
            this.logger.info((Object)("[modules] eval file: " + jsFiles));
            if (jsFiles.size() == 0) {
                this.logger.warn((Object)"no files were transpiled");
                return EvaluationResult.VOID;
            }
            File mainFile = jsFiles.iterator().next();
            runProcess = this.runScript(trace, mainFile);
        } else {
            File tmpFile = new File(this.options.workingDir, "eval.tmp.js");
            FileUtils.deleteQuietly((File)tmpFile);
            HashSet<File> alreadyWrittenScripts = new HashSet<File>();
            for (File jsFile : jsFiles) {
                if (alreadyWrittenScripts.contains(jsFile)) continue;
                String script = FileUtils.readFileToString((File)jsFile);
                FileUtils.write((File)tmpFile, (CharSequence)(script + "\n"), (boolean)true);
                alreadyWrittenScripts.add(jsFile);
            }
            this.logger.info((Object)("[no modules] eval file: " + tmpFile + " jsFiles=" + jsFiles));
            runProcess = this.runScript(trace, tmpFile);
        }
        int returnCode = runProcess.exitValue();
        this.logger.info((Object)("return code=" + returnCode));
        if (returnCode != 0) {
            throw new Exception("evaluation error (code=" + returnCode + ") - trace=" + trace);
        }
        return new TraceBasedEvaluationResult(trace.getBuffer().toString());
    }

    private Process runScript(StringWriter trace, File mainFile) throws IOException {
        Process runProcess;
        if (this.runtime == JavaScriptRuntime.PhantomJs) {
            this.checkPhantomJsInstall();
            String phantomJsPath = this.resolvePhantomJsPath();
            runProcess = ProcessUtil.runCommand(phantomJsPath, null, false, line -> {
                this.logger.info((Object)("PHANTOM OUT: " + line));
                if (line.startsWith("TEST_DATA_ERROR")) {
                    String errorMessage = line.split("[:]")[1];
                    throw new RuntimeException("error during execution: " + errorMessage);
                }
                trace.append(line + "\n");
            }, process -> {
                this.logger.info((Object)("PHANTOM END - " + process));
                trace.append("phantom ended\n");
            }, () -> {
                trace.append("phantom errored\n");
                this.logger.info((Object)"phantomERROR :(");
            }, "--webdriver-loglevel=DEBUG", mainFile.getPath());
        } else {
            runProcess = ProcessUtil.runCommand(ProcessUtil.NODE_COMMAND, line -> trace.append(line + "\n"), null, mainFile.getPath());
        }
        return runProcess;
    }

    public String resolvePhantomJsPath() {
        String phantomJsPath = ProcessUtil.getGlobalNpmPackageExecutablePath(PHANTOMJS_EXECUTABLE_NAME);
        if (ProcessUtil.isWindows() && ((phantomJsPath = ProcessUtil.findGlobalExecutable("phantomjs.exe", PHANTOMJS_PACKAGE_NAME)) == null || !new File(phantomJsPath).isFile())) {
            phantomJsPath = ProcessUtil.getGlobalNpmPackageExecutablePath(PHANTOMJS_EXECUTABLE_NAME);
        }
        this.logger.info((Object)("phantomJsPath=" + phantomJsPath));
        if (!new File(phantomJsPath).canExecute()) {
            throw new RuntimeException("phantomjs cannot be found");
        }
        return phantomJsPath;
    }

    private void checkPhantomJsInstall() {
        if (!ProcessUtil.isInstalledWithNpm(PHANTOMJS_EXECUTABLE_NAME)) {
            ProcessUtil.installNodePackage(PHANTOMJS_PACKAGE_NAME, null, true);
        }
    }

    public static enum JavaScriptRuntime {
        NodeJs,
        PhantomJs;

    }
}

