/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.util.Util;

public class JSDoc {
    public static final Pattern paramPattern = Pattern.compile("(\\s*@param\\s+)(\\w+)(.*)");
    public static final Pattern authorPattern = Pattern.compile("(\\s*@author\\s+)(\\w+)(.*)");
    public static final Pattern returnPattern = Pattern.compile("(\\s*@return\\s+)(.*)");
    public static final Pattern linkPattern = Pattern.compile("(\\{@link\\s+)([\\w\\.#,]+)\\s+[^}]*(\\})");

    private JSDoc() {
    }

    public static String getMappedDocType(JSweetContext context, JCTree typeTree, Type type) {
        String qualifiedName = type.toString();
        if (typeTree instanceof JCTree.JCTypeApply) {
            qualifiedName = ((JCTree.JCTypeApply)typeTree).clazz.type.toString();
        }
        if (type instanceof Type.TypeVar) {
            Type.TypeVar typeVar = (Type.TypeVar)typeTree.type;
            if (typeVar.getUpperBound() == null) {
                return "*";
            }
            return JSDoc.getMappedDocType(context, null, typeVar.getUpperBound());
        }
        boolean isMapped = false;
        if (typeTree != null) {
            for (BiFunction<ExtendedElement, String, Object> mapping : context.getFunctionalTypeMappings()) {
                Object mapped = mapping.apply(new ExtendedElementSupport<JCTree>(typeTree), qualifiedName);
                if (mapped instanceof String) {
                    isMapped = true;
                    qualifiedName = (String)mapped;
                    continue;
                }
                if (!(mapped instanceof JCTree)) continue;
                isMapped = true;
                qualifiedName = JSDoc.getMappedDocType(context, (JCTree)mapped, ((JCTree)mapped).type);
            }
        }
        if (context.isMappedType(qualifiedName)) {
            isMapped = true;
            qualifiedName = context.getTypeMappingTarget(qualifiedName);
        }
        if (!isMapped && !type.isPrimitiveOrVoid()) {
            qualifiedName = context.getRootRelativeName(null, type.tsym);
        }
        if ("Array".equals(qualifiedName) && typeTree instanceof JCTree.JCTypeApply) {
            return JSDoc.getMappedDocType(context, (JCTree)((JCTree.JCTypeApply)typeTree).arguments.head, ((JCTree.JCExpression)((JCTree.JCTypeApply)typeTree).arguments.head).type) + "[]";
        }
        if (typeTree instanceof JCTree.JCTypeApply) {
            return JSDoc.getMappedDocType(context, ((JCTree.JCTypeApply)typeTree).clazz, ((JCTree.JCTypeApply)typeTree).clazz.type);
        }
        if (!isMapped && context.isInterface(type.tsym)) {
            return "*";
        }
        return "any".equals(qualifiedName) ? "*" : qualifiedName;
    }

    public static String replaceLinks(JSweetContext context, String text) {
        Matcher linkMatcher = linkPattern.matcher(text);
        boolean result = linkMatcher.find();
        int lastMatch = 0;
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                sb.append(text.substring(lastMatch, linkMatcher.start()));
                sb.append(linkMatcher.group(1));
                Symbol.ClassSymbol type = Util.getTypeByName(context, linkMatcher.group(2));
                sb.append(type == null ? linkMatcher.group(2) : JSDoc.getMappedDocType(context, null, type.type));
                sb.append(linkMatcher.group(3));
                lastMatch = linkMatcher.end();
            } while (result = linkMatcher.find());
            sb.append(text.substring(lastMatch));
            return sb.toString();
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String adaptDocComment(JSweetContext context, JCTree.JCCompilationUnit compilationUnit, JCTree element, String commentText) {
        if (element instanceof JCTree.JCClassDecl) {
            JCTree.JCMethodDecl mainConstructor = null;
            for (JCTree member : ((JCTree.JCClassDecl)element).defs) {
                if (!(member instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)member).sym.isConstructor() || !((JCTree.JCMethodDecl)member).getModifiers().getFlags().contains((Object)Modifier.PUBLIC) || mainConstructor != null && ((List)mainConstructor.getParameters()).size() >= ((List)((JCTree.JCMethodDecl)member).getParameters()).size()) continue;
                mainConstructor = (JCTree.JCMethodDecl)member;
            }
            if (mainConstructor != null) {
                ArrayList<String> commentLines;
                Tokens.Comment comment = compilationUnit.docComments.getComment(mainConstructor);
                String author = null;
                if (comment != null) {
                    commentLines = commentText == null ? null : new ArrayList<String>(Arrays.asList(commentText.split("\n")));
                    commentText = comment.getText();
                    if (commentLines != null) {
                        for (String line : commentLines) {
                            if (!authorPattern.matcher(line).matches()) continue;
                            author = line;
                            break;
                        }
                    }
                }
                if (commentText != null) {
                    commentText = JSDoc.replaceLinks(context, commentText);
                    commentLines = new ArrayList<String>(Arrays.asList(commentText.split("\n")));
                    JSDoc.applyForMethod(context, mainConstructor, commentLines);
                    JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)element;
                    if (clazz.sym.isEnum()) {
                        commentLines.add(" @enum");
                    }
                    if (clazz.extending != null) {
                        commentLines.add(" @extends " + JSDoc.getMappedDocType(context, clazz.extending, clazz.extending.type));
                    }
                    if (author == null) return String.join((CharSequence)"\n", commentLines);
                    commentLines.add(author);
                    return String.join((CharSequence)"\n", commentLines);
                }
            }
        }
        ArrayList<String> commentLines = null;
        if (commentText == null && element instanceof JCTree.JCMethodDecl && context.hasAnnotationType(((JCTree.JCMethodDecl)element).sym, Override.class.getName())) {
            commentText = "";
            commentLines = new ArrayList();
            JSDoc.applyForMethod(context, (JCTree.JCMethodDecl)element, commentLines);
        }
        if (commentText == null) {
            return null;
        }
        commentText = JSDoc.replaceLinks(context, commentText);
        commentLines = new ArrayList<String>(Arrays.asList(commentText.split("\n")));
        if (element instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)element;
            if (method.sym.isConstructor()) return null;
            JSDoc.applyForMethod(context, method, commentLines);
            return String.join((CharSequence)"\n", commentLines);
        } else {
            if (!(element instanceof JCTree.JCClassDecl)) return String.join((CharSequence)"\n", commentLines);
            JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)element;
            if (clazz.sym.isEnum()) {
                commentLines.add(" @enum");
                for (JCTree def : clazz.defs) {
                    String text;
                    if (!(def instanceof JCTree.JCVariableDecl)) continue;
                    JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)def;
                    if (var.sym.getModifiers() == null || !var.sym.getModifiers().contains((Object)Modifier.PUBLIC) || !var.sym.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    commentLines.add("@property {" + JSDoc.getMappedDocType(context, var.getType(), var.getType().type) + "} " + var.getName().toString());
                    Tokens.Comment varComment = compilationUnit.docComments.getComment(var);
                    if (varComment == null || (text = varComment.getText()) == null) continue;
                    text = JSDoc.replaceLinks(context, text);
                    commentLines.addAll(new ArrayList<String>(Arrays.asList(text.split("\n"))));
                }
            }
            if (clazz.extending != null) {
                commentLines.add(" @extends " + JSDoc.getMappedDocType(context, clazz.extending, clazz.extending.type));
            }
            commentLines.add(" @class");
        }
        return String.join((CharSequence)"\n", commentLines);
    }

    private static void applyForMethod(JSweetContext context, JCTree.JCMethodDecl method, java.util.List<String> commentLines) {
        String name;
        HashSet<String> params = new HashSet<String>();
        boolean hasReturn = false;
        for (int i = 0; i < commentLines.size(); ++i) {
            Matcher m = paramPattern.matcher(commentLines.get(i));
            if (m.matches()) {
                name = m.group(2);
                params.add(name);
                JCTree.JCVariableDecl parameter = Util.findParameter(method, name);
                if (parameter == null) continue;
                commentLines.set(i, m.group(1) + "{" + JSDoc.getMappedDocType(context, parameter.vartype, parameter.vartype.type) + "} " + m.group(2) + m.group(3));
                continue;
            }
            m = returnPattern.matcher(commentLines.get(i));
            if (!m.matches()) continue;
            hasReturn = true;
            if (method.restype == null) continue;
            commentLines.set(i, m.group(1) + "{" + JSDoc.getMappedDocType(context, method.restype, method.restype.type) + "} " + m.group(2));
        }
        for (JCTree.JCVariableDecl parameter : method.getParameters()) {
            name = parameter.name.toString();
            if (params.contains(name)) continue;
            commentLines.add(" @param {" + JSDoc.getMappedDocType(context, parameter.vartype, parameter.vartype.type) + "} " + name);
        }
        if (!(hasReturn || method.restype == null || context.symtab.voidType.equals(method.restype.type) || method.sym.isConstructor())) {
            commentLines.add(" @return {" + JSDoc.getMappedDocType(context, method.restype, method.restype.type) + "}");
        }
        if (method.sym.isPrivate()) {
            commentLines.add(" @private");
        }
        if (method.sym.isConstructor()) {
            commentLines.add(" @class");
        }
    }
}

