/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.EnumeratedStringParser;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.JSweetFileWatcher;
import org.jsweet.TranspilationTask;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetFactory;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.ModuleKind;
import org.jsweet.transpiler.ModuleResolution;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.ConsoleTranspilationHandler;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.ProcessUtil;
import org.jsweet.transpiler.util.Util;

public class JSweetCommandLineLauncher {
    private static final Logger logger = Logger.getLogger(JSweetCommandLineLauncher.class);
    private static int errorCount = 0;

    private static Pattern toPattern(String expression) {
        if (!expression.contains("*") && !expression.contains(".")) {
            expression = expression + "*";
        }
        return Pattern.compile(expression.replace(".", "\\.").replace("*", ".*"));
    }

    private JSweetCommandLineLauncher() {
    }

    public static void main(String[] args) {
        System.exit(JSweetCommandLineLauncher.transpileWithArgs(args));
    }

    public static int transpileWithArgs(String[] args) {
        try {
            JSAP jsapSpec = JSweetCommandLineLauncher.defineArgs();
            JSAPResult jsapArgs = JSweetCommandLineLauncher.parseArgs(jsapSpec, args);
            if (!jsapArgs.success()) {
                JSweetCommandLineLauncher.printUsage(jsapSpec);
                return -1;
            }
            if (jsapArgs.getBoolean("help")) {
                JSweetCommandLineLauncher.printUsage(jsapSpec);
            }
            LogManager.getLogger((String)"org.jsweet").setLevel(Level.WARN);
            if (jsapArgs.getBoolean("verbose")) {
                LogManager.getLogger((String)"org.jsweet").setLevel(Level.INFO);
            }
            if (jsapArgs.getBoolean("veryVerbose")) {
                LogManager.getLogger((String)"org.jsweet").setLevel(Level.ALL);
            }
            JSweetConfig.initClassPath(jsapArgs.getString("jdkHome"));
            JSweetTranspilationTask transpilationTask = new JSweetTranspilationTask(jsapArgs);
            transpilationTask.run();
            if (jsapArgs.getBoolean("watch")) {
                new JSweetFileWatcher(transpilationTask).execute();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
        return errorCount > 0 ? 1 : 0;
    }

    private static JSAP defineArgs() throws JSAPException {
        JSAP jsap = new JSAP();
        Switch switchArg = new Switch("help");
        switchArg.setShortFlag('h');
        switchArg.setLongFlag("help");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("watch");
        switchArg.setShortFlag('w');
        switchArg.setLongFlag("watch");
        switchArg.setDefault("false");
        switchArg.setHelp("Start a process that watches the input directories for changes and re-run transpilation on-the-fly.");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("verbose");
        switchArg.setLongFlag("verbose");
        switchArg.setShortFlag('v');
        switchArg.setHelp("Turn on general information logging (INFO LEVEL)");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("veryVerbose");
        switchArg.setLongFlag("veryVerbose");
        switchArg.setShortFlag('V');
        switchArg.setHelp("Turn on all levels of logging.");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        FlaggedOption optionArg = new FlaggedOption("encoding");
        optionArg.setLongFlag("encoding");
        optionArg.setStringParser((StringParser)JSAP.STRING_PARSER);
        optionArg.setRequired(false);
        optionArg.setDefault("UTF-8");
        optionArg.setHelp("Force the Java compiler to use a specific encoding (UTF-8, UTF-16, ...).");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("outEncoding");
        optionArg.setLongFlag("outEncoding");
        optionArg.setStringParser((StringParser)JSAP.STRING_PARSER);
        optionArg.setRequired(false);
        optionArg.setDefault("UTF-8");
        optionArg.setHelp("Force the generated TypeScript output code for the given encoding (UTF-8, UTF-16, ...).");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("jdkHome");
        optionArg.setLongFlag("jdkHome");
        optionArg.setStringParser((StringParser)JSAP.STRING_PARSER);
        optionArg.setRequired(false);
        optionArg.setHelp("Set the JDK home directory to be used to find the Java compiler. If not set, the transpiler will try to use the JAVA_HOME environment variable. Note that the expected JDK version is greater or equals to version 8.");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("input");
        optionArg.setShortFlag('i');
        optionArg.setLongFlag("input");
        optionArg.setList(true);
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setListSeparator(File.pathSeparatorChar);
        optionArg.setRequired(true);
        optionArg.setHelp("An input directory (or column-separated input directories) containing Java files to be transpiled. Java files will be recursively looked up in sub-directories. Inclusion and exclusion patterns can be defined with the 'includes' and 'excludes' options.");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("extraInput");
        optionArg.setLongFlag("extraInput");
        optionArg.setList(true);
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setListSeparator(File.pathSeparatorChar);
        optionArg.setHelp("An input directory (or column-separated input directories) containing Java source files to help the tranpilation (typically for libraries). Files in these directories will not generate any corresponding TS files but will help resolving various generation issues (such as default methods, tricking overloading cases, ...).");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("includes");
        optionArg.setLongFlag("includes");
        optionArg.setList(true);
        optionArg.setListSeparator(File.pathSeparatorChar);
        optionArg.setHelp("A column-separated list of expressions matching files to be included (relatively to the input directory).");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("excludes");
        optionArg.setLongFlag("excludes");
        optionArg.setList(true);
        optionArg.setListSeparator(File.pathSeparatorChar);
        optionArg.setHelp("A column-separated list of expressions matching files to be excluded (relatively to the input directory).");
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("defInput");
        optionArg.setShortFlag('d');
        optionArg.setLongFlag("defInput");
        optionArg.setList(true);
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setListSeparator(File.pathSeparatorChar);
        optionArg.setRequired(false);
        optionArg.setHelp("An input directory (or column-separated input directories) containing TypeScript definition files (*.d.ts) to be used for transpilation. Definition files will be recursively looked up in sub-diredctories.");
        jsap.registerParameter((Parameter)optionArg);
        switchArg = new Switch("noRootDirectories");
        switchArg.setLongFlag("noRootDirectories");
        switchArg.setHelp("Skip the root directories (i.e. packages annotated with @jsweet.lang.Root) so that the generated file hierarchy starts at the root directories rather than including the entire directory structure.");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        optionArg = new FlaggedOption("tsout");
        optionArg.setLongFlag("tsout");
        optionArg.setDefault(".ts");
        optionArg.setHelp("Specify where to place generated TypeScript files.");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("jsout");
        optionArg.setShortFlag('o');
        optionArg.setLongFlag("jsout");
        optionArg.setDefault("js");
        optionArg.setHelp("Specify where to place generated JavaScript files (ignored if jsFile is specified).");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        switchArg = new Switch("disableSinglePrecisionFloats");
        switchArg.setLongFlag("disableSinglePrecisionFloats");
        switchArg.setHelp("By default, for a target version >=ES5, JSweet will force Java floats to be mapped to JavaScript numbers that will be constrained with ES5 Math.fround function. If this option is true, then the calls to Math.fround are erased and the generated program will use the JavaScript default precision (double precision).");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("tsOnly");
        switchArg.setLongFlag("tsOnly");
        switchArg.setHelp("Do not compile the TypeScript output (let an external TypeScript compiler do so).");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("ignoreDefinitions");
        switchArg.setLongFlag("ignoreDefinitions");
        switchArg.setHelp("Ignore definitions from def.* packages, so that they are not generated in d.ts definition files. If this option is not set, the transpiler generates d.ts definition files in the directory given by the tsout option.");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("ignoreJavaErrors");
        switchArg.setLongFlag("ignoreJavaErrors");
        switchArg.setHelp("Ignore Java compilation errors. Do not use unless you know what you are doing.");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("declaration");
        switchArg.setLongFlag("declaration");
        switchArg.setHelp("Generate the d.ts files along with the js files, so that other programs can use them to compile.");
        jsap.registerParameter((Parameter)switchArg);
        optionArg = new FlaggedOption("dtsout");
        optionArg.setLongFlag("dtsout");
        optionArg.setHelp("Specify where to place generated d.ts files when the declaration option is set (by default, d.ts files are generated in the JavaScript output directory - next to the corresponding js files).");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("candiesJsOut");
        optionArg.setLongFlag("candiesJsOut");
        optionArg.setDefault("js/candies");
        optionArg.setHelp("Specify where to place extracted JavaScript files from candies.");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("sourceRoot");
        optionArg.setLongFlag("sourceRoot");
        optionArg.setHelp("Specify the location where debugger should locate Java files instead of source locations. Use this flag if the sources will be located at run-time in a different location than that at design-time. The location specified will be embedded in the sourceMap to direct the debugger where the source files will be located.");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("classpath");
        optionArg.setLongFlag("classpath");
        optionArg.setHelp("The JSweet transpilation classpath (candy jars). This classpath should at least contain the core candy.");
        optionArg.setStringParser((StringParser)JSAP.STRING_PARSER);
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("module");
        optionArg.setLongFlag("module");
        optionArg.setShortFlag('m');
        optionArg.setDefault("none");
        optionArg.setHelp("The module kind (none, commonjs, amd, system, umd, es2015).");
        optionArg.setStringParser((StringParser)EnumeratedStringParser.getParser((String)"none;commonjs;amd;system;umd;es2015"));
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("moduleResolution");
        optionArg.setLongFlag("moduleResolution");
        optionArg.setDefault(ModuleResolution.classic.name());
        optionArg.setHelp("The module resolution strategy (classic, node).");
        optionArg.setStringParser((StringParser)EnumeratedStringParser.getParser((String)"classic;node"));
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        switchArg = new Switch("bundle");
        switchArg.setLongFlag("bundle");
        switchArg.setShortFlag('b');
        switchArg.setHelp("Bundle up all the generated code in a single file, which can be used in the browser. The bundle files are called 'bundle.ts', 'bundle.d.ts', or 'bundle.js' depending on the kind of generated code. NOTE: bundles are not compatible with any module kind other than 'none'.");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        optionArg = new FlaggedOption("factoryClassName");
        optionArg.setLongFlag("factoryClassName");
        optionArg.setShortFlag('f');
        optionArg.setHelp("Use the given factory to tune the default transpiler behavior.");
        optionArg.setStringParser((StringParser)JSAP.STRING_PARSER);
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        switchArg = new Switch("sourceMap");
        switchArg.setLongFlag("sourceMap");
        switchArg.setHelp("Generate source map files for the Java files, so that it is possible to debug Java files directly with a debugger that supports source maps (most JavaScript debuggers).");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        switchArg = new Switch("enableAssertions");
        switchArg.setLongFlag("enableAssertions");
        switchArg.setHelp("Java 'assert' statements are transpiled as runtime JavaScript checks.");
        switchArg.setDefault("false");
        jsap.registerParameter((Parameter)switchArg);
        optionArg = new FlaggedOption("header");
        optionArg.setLongFlag("header");
        optionArg.setHelp("A file that contains a header to be written at the beginning of each generated file. If left unspecified, JSweet will generate a default header.");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("workingDir");
        optionArg.setLongFlag("workingDir");
        optionArg.setHelp("The directory JSweet uses to store temporary files such as extracted candies. JSweet uses '.jsweet' if left unspecified.");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("targetVersion");
        optionArg.setLongFlag("targetVersion");
        optionArg.setHelp("The EcmaScript target (JavaScript) version. Possible values: " + Arrays.asList(EcmaScriptComplianceLevel.values()));
        optionArg.setDefault("ES3");
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        optionArg = new FlaggedOption("extraSystemPath");
        optionArg.setLongFlag("extraSystemPath");
        optionArg.setHelp("Allow an extra path to be added to the system path.");
        optionArg.setStringParser((StringParser)FileStringParser.getParser());
        optionArg.setRequired(false);
        jsap.registerParameter((Parameter)optionArg);
        switchArg = new Switch("disableStaticsLazyInitialization");
        switchArg.setLongFlag("disableStaticsLazyInitialization");
        switchArg.setHelp("Do not generate lazy initialization code of static fields that is meant to emulate the Java behavior. When disables, the code is more readable but it may result into runtime static initialization issues (cross-class static dependencies).");
        jsap.registerParameter((Parameter)switchArg);
        return jsap;
    }

    private static JSAPResult parseArgs(JSAP jsapSpec, String[] commandLineArgs) {
        TranspilationHandler.OUTPUT_LOGGER.info((Object)("JSweet transpiler version " + JSweetConfig.getVersionNumber() + " (build date: " + JSweetConfig.getBuildDate() + ")"));
        if (jsapSpec == null) {
            throw new IllegalStateException("no args, please call setArgs before");
        }
        JSAPResult arguments = jsapSpec.parse(commandLineArgs);
        if (!arguments.success()) {
            Iterator errs = arguments.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.out.println("Error: " + errs.next());
            }
        }
        if (!arguments.success() || arguments.getBoolean("help")) {
            // empty if block
        }
        return arguments;
    }

    private static void printUsage(JSAP jsapSpec) {
        System.out.println("Command line options:");
        System.out.println(jsapSpec.getHelp());
    }

    private static class JSweetTranspilationTask
    implements TranspilationTask {
        private JSAPResult jsapArgs;
        private List<File> inputDirList;
        private List<File> extraInputDirList;
        private LinkedList<File> javaInputFiles;
        private LinkedList<File> extraJavaInputFiles;

        public JSweetTranspilationTask(JSAPResult jsapArgs) {
            this.jsapArgs = jsapArgs;
            this.inputDirList = new ArrayList<File>();
            this.inputDirList.addAll(Arrays.asList(jsapArgs.getFileArray("input")));
            if (jsapArgs.userSpecified("extraInput")) {
                this.extraInputDirList = Arrays.asList(jsapArgs.getFileArray("extraInput"));
            }
            logger.info((Object)("input dirs: " + this.inputDirList));
        }

        @Override
        public List<File> getInputDirList() {
            return this.inputDirList;
        }

        @Override
        public void run() throws Exception {
            String classPath = this.jsapArgs.getString("classpath");
            logger.info((Object)("classpath: " + classPath));
            ErrorCountTranspilationHandler transpilationHandler = new ErrorCountTranspilationHandler(new ConsoleTranspilationHandler());
            try {
                String[] included = this.jsapArgs.getStringArray("includes");
                String[] excluded = this.jsapArgs.getStringArray("excludes");
                List includedPatterns = included == null ? null : Arrays.asList(included).stream().map(s -> JSweetCommandLineLauncher.toPattern(s)).collect(Collectors.toList());
                List excludedPatterns = excluded == null ? null : Arrays.asList(excluded).stream().map(s -> JSweetCommandLineLauncher.toPattern(s)).collect(Collectors.toList());
                logger.info((Object)("included: " + includedPatterns));
                logger.info((Object)("excluded: " + excludedPatterns));
                this.javaInputFiles = new LinkedList();
                for (File inputDir : this.inputDirList) {
                    Util.addFiles(f -> {
                        String path = inputDir.toURI().relativize(f.toURI()).getPath();
                        if (path.endsWith(".java") && (includedPatterns == null || includedPatterns.isEmpty() || includedPatterns != null && includedPatterns.stream().anyMatch(p -> p.matcher(path).matches()))) {
                            return excludedPatterns == null || excludedPatterns.isEmpty() || !excludedPatterns.stream().anyMatch(p -> p.matcher(path).matches());
                        }
                        return false;
                    }, inputDir, this.javaInputFiles);
                }
                this.extraJavaInputFiles = new LinkedList();
                if (this.extraInputDirList != null) {
                    for (File inputDir : this.extraInputDirList) {
                        Util.addFiles(f -> {
                            String path = inputDir.toURI().relativize(f.toURI()).getPath();
                            if (path.endsWith(".java") && (includedPatterns == null || includedPatterns.isEmpty() || includedPatterns != null && includedPatterns.stream().anyMatch(p -> p.matcher(path).matches()))) {
                                return excludedPatterns == null || excludedPatterns.isEmpty() || !excludedPatterns.stream().anyMatch(p -> p.matcher(path).matches());
                            }
                            return false;
                        }, inputDir, this.extraJavaInputFiles);
                    }
                }
                this.javaInputFiles.addAll(this.extraJavaInputFiles);
                File tsOutputDir = null;
                if (this.jsapArgs.userSpecified("tsout") && this.jsapArgs.getFile("tsout") != null) {
                    tsOutputDir = this.jsapArgs.getFile("tsout");
                    tsOutputDir.mkdirs();
                }
                logger.info((Object)("ts output dir: " + tsOutputDir));
                File jsOutputDir = null;
                if (this.jsapArgs.userSpecified("jsout") && this.jsapArgs.getFile("jsout") != null) {
                    jsOutputDir = this.jsapArgs.getFile("jsout");
                    jsOutputDir.mkdirs();
                }
                logger.info((Object)("js output dir: " + jsOutputDir));
                File dtsOutputDir = null;
                if (this.jsapArgs.userSpecified("dtsout") && this.jsapArgs.getFile("dtsout") != null) {
                    dtsOutputDir = this.jsapArgs.getFile("dtsout");
                }
                File candiesJsOutputDir = null;
                if (this.jsapArgs.userSpecified("candiesJsOut") && this.jsapArgs.getFile("candiesJsOut") != null) {
                    candiesJsOutputDir = this.jsapArgs.getFile("candiesJsOut");
                }
                File sourceRootDir = null;
                if (this.jsapArgs.userSpecified("sourceRoot") && this.jsapArgs.getFile("sourceRoot") != null) {
                    sourceRootDir = this.jsapArgs.getFile("sourceRoot");
                }
                JSweetFactory factory = null;
                String factoryClassName = this.jsapArgs.getString("factoryClassName");
                if (factoryClassName != null) {
                    try {
                        factory = (JSweetFactory)Thread.currentThread().getContextClassLoader().loadClass(factoryClassName).newInstance();
                    }
                    catch (Exception e) {
                        try {
                            factory = (JSweetFactory)Class.forName(factoryClassName).newInstance();
                        }
                        catch (Exception e2) {
                            throw new RuntimeException("cannot find or instantiate factory class: " + factoryClassName + " (make sure the class is in the plugin's classpath and that it defines an empty public constructor)", e2);
                        }
                    }
                }
                if (factory == null) {
                    factory = new JSweetFactory();
                }
                JSweetTranspiler transpiler = new JSweetTranspiler(factory, this.jsapArgs.getFile("workingDir"), tsOutputDir, jsOutputDir, candiesJsOutputDir, classPath);
                if (this.jsapArgs.userSpecified("bundle")) {
                    transpiler.setBundle(this.jsapArgs.getBoolean("bundle"));
                }
                if (this.jsapArgs.userSpecified("noRootDirectories")) {
                    transpiler.setNoRootDirectories(this.jsapArgs.getBoolean("noRootDirectories"));
                }
                if (this.jsapArgs.userSpecified("sourceMap")) {
                    transpiler.setGenerateSourceMaps(this.jsapArgs.getBoolean("sourceMap"));
                }
                if (sourceRootDir != null) {
                    transpiler.setSourceRoot(sourceRootDir);
                }
                if (this.jsapArgs.userSpecified("module")) {
                    transpiler.setModuleKind(ModuleKind.valueOf(this.jsapArgs.getString("module")));
                }
                if (this.jsapArgs.userSpecified("moduleResolution")) {
                    transpiler.setModuleResolution(ModuleResolution.valueOf(this.jsapArgs.getString("moduleResolution")));
                }
                if (this.jsapArgs.userSpecified("encoding")) {
                    transpiler.setEncoding(this.jsapArgs.getString("encoding"));
                }
                if (this.jsapArgs.userSpecified("outEncoding")) {
                    transpiler.setOutEncoding(this.jsapArgs.getString("outEncoding"));
                }
                if (this.jsapArgs.userSpecified("enableAssertions")) {
                    transpiler.setIgnoreAssertions(!this.jsapArgs.getBoolean("enableAssertions"));
                }
                if (this.jsapArgs.userSpecified("declaration")) {
                    transpiler.setGenerateDeclarations(this.jsapArgs.getBoolean("declaration"));
                }
                if (this.jsapArgs.userSpecified("tsOnly")) {
                    transpiler.setGenerateJsFiles(!this.jsapArgs.getBoolean("tsOnly"));
                }
                if (this.jsapArgs.userSpecified("ignoreDefinitions")) {
                    transpiler.setGenerateDefinitions(!this.jsapArgs.getBoolean("ignoreDefinitions"));
                }
                if (this.jsapArgs.userSpecified("ignoreJavaErrors")) {
                    transpiler.setIgnoreJavaErrors(this.jsapArgs.getBoolean("ignoreJavaErrors"));
                }
                if (this.jsapArgs.userSpecified("dtsout")) {
                    transpiler.setDeclarationsOutputDir(dtsOutputDir);
                }
                if (this.jsapArgs.userSpecified("header")) {
                    transpiler.setHeaderFile(this.jsapArgs.getFile("header"));
                }
                if (this.jsapArgs.userSpecified("targetVersion")) {
                    transpiler.setEcmaTargetVersion(JSweetTranspiler.getEcmaTargetVersion(this.jsapArgs.getString("targetVersion")));
                }
                if (this.jsapArgs.userSpecified("disableSinglePrecisionFloats")) {
                    transpiler.setDisableSinglePrecisionFloats(this.jsapArgs.getBoolean("disableSinglePrecisionFloats"));
                }
                if (this.jsapArgs.userSpecified("extraSystemPath")) {
                    ProcessUtil.addExtraPath(this.jsapArgs.getString("extraSystemPath"));
                }
                if (this.jsapArgs.userSpecified("disableStaticsLazyInitialization")) {
                    transpiler.setLazyInitializedStatics(!this.jsapArgs.getBoolean("disableStaticsLazyInitialization"));
                }
                if (tsOutputDir != null) {
                    transpiler.setTsOutputDir(tsOutputDir);
                }
                if (jsOutputDir != null) {
                    transpiler.setJsOutputDir(jsOutputDir);
                }
                List<File> files = Arrays.asList(this.jsapArgs.getFileArray("defInput"));
                logger.info((Object)("definition input dirs: " + files));
                for (File f2 : files) {
                    transpiler.addTsDefDir(f2);
                }
                transpiler.transpile((TranspilationHandler)transpilationHandler, this.extraJavaInputFiles.stream().map(f -> f.toString()).collect(Collectors.toSet()), SourceFile.toSourceFiles(this.javaInputFiles));
            }
            catch (NoClassDefFoundError error) {
                transpilationHandler.report(JSweetProblem.JAVA_COMPILER_NOT_FOUND, null, JSweetProblem.JAVA_COMPILER_NOT_FOUND.getMessage(new Object[0]));
            }
            errorCount = transpilationHandler.getErrorCount();
            if (errorCount > 0) {
                TranspilationHandler.OUTPUT_LOGGER.info((Object)("transpilation failed with " + errorCount + " error(s) and " + transpilationHandler.getWarningCount() + " warning(s)"));
            } else if (transpilationHandler.getWarningCount() > 0) {
                TranspilationHandler.OUTPUT_LOGGER.info((Object)("transpilation completed with " + transpilationHandler.getWarningCount() + " warning(s)"));
            } else {
                TranspilationHandler.OUTPUT_LOGGER.info((Object)"transpilation successfully completed with no errors and no warnings");
            }
        }
    }
}

