/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model.support;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.model.Util;

public class UtilSupport
implements Util {
    protected JSweetContext context;

    public UtilSupport(JSweetContext context) {
        this.context = context;
    }

    @Override
    public String getQualifiedName(TypeMirror type) {
        Element e;
        if (type instanceof DeclaredType && (e = ((DeclaredType)type).asElement()) instanceof TypeElement) {
            return ((TypeElement)e).getQualifiedName().toString();
        }
        return type.toString();
    }

    @Override
    public TypeMirror getUpperBound(TypeMirror type) {
        if (type instanceof Type.CapturedType && ((Type.CapturedType)type).bound != null) {
            return ((Type.CapturedType)type).bound;
        }
        return type;
    }

    @Override
    public List<? extends TypeMirror> getTypeArguments(TypeMirror type) {
        if (type instanceof DeclaredType) {
            return ((DeclaredType)type).getTypeArguments();
        }
        return null;
    }

    @Override
    public TypeMirror getType(Class<?> clazz) {
        switch (clazz.getName()) {
            case "java.lang.annotation.Annotation": {
                return this.context.symtab.annotationType;
            }
            case "java.lang.AssertionError": {
                return this.context.symtab.assertionErrorType;
            }
            case "java.lang.ClassLoader": {
                return this.context.symtab.classLoaderType;
            }
            case "java.lang.AutoCloseable": {
                return this.context.symtab.autoCloseableType;
            }
            case "java.lang.ClassNotFoundException": {
                return this.context.symtab.classNotFoundExceptionType;
            }
            case "java.util.Collections": {
                return this.context.symtab.collectionsType;
            }
            case "java.lang.Comparable": {
                return this.context.symtab.comparableType;
            }
            case "java.lang.IllegalArgumentException": {
                return this.context.symtab.illegalArgumentExceptionType;
            }
            case "java.lang.Error": {
                return this.context.symtab.errorType;
            }
            case "java.lang.StringBuffer": {
                return this.context.symtab.stringBufferType;
            }
            case "java.lang.StringBuilder": {
                return this.context.symtab.stringBuilderType;
            }
            case "java.lang.String": {
                return this.context.symtab.stringType;
            }
            case "java.lang.InterruptedException": {
                return this.context.symtab.interruptedExceptionType;
            }
            case "java.lang.Iterable": {
                return this.context.symtab.iterableType;
            }
            case "java.util.Iterator": {
                return this.context.symtab.iteratorType;
            }
            case "java.lang.RuntimeException": {
                return this.context.symtab.runtimeExceptionType;
            }
            case "java.lang.NoClassDefFoundError": {
                return this.context.symtab.noClassDefFoundErrorType;
            }
            case "java.lang.NoSuchFieldError": {
                return this.context.symtab.noSuchFieldErrorType;
            }
            case "java.lang.Throwable": {
                return this.context.symtab.throwableType;
            }
            case "java.util.List": {
                return this.context.symtab.listType;
            }
        }
        return null;
    }

    @Override
    public TypeMirror getType(String fullyQualifiedName) {
        TypeMirror result = null;
        try {
            Class<?> clazz = Class.forName(fullyQualifiedName);
            result = this.getType(clazz);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (JCTree.JCCompilationUnit cu : this.context.compilationUnits) {
            for (JCTree t : cu.getTypeDecls()) {
                if (!(t.type.asElement() instanceof TypeElement) || !t.type.asElement().toString().equals(fullyQualifiedName)) continue;
                return t.type;
            }
        }
        return null;
    }

    @Override
    public boolean isNumber(TypeMirror type) {
        return org.jsweet.transpiler.util.Util.isNumber(type);
    }

    @Override
    public boolean isDeprecated(Element element) {
        return org.jsweet.transpiler.util.Util.isDeprecated(element);
    }

    @Override
    public boolean isCoreType(TypeMirror type) {
        return org.jsweet.transpiler.util.Util.isCoreType(type);
    }

    @Override
    public boolean isIntegral(TypeMirror type) {
        return org.jsweet.transpiler.util.Util.isIntegral((Type)type);
    }

    @Override
    public boolean isSourceElement(Element element) {
        return org.jsweet.transpiler.util.Util.isSourceElement(element);
    }

    @Override
    public String getSourceFilePath(Element element) {
        return org.jsweet.transpiler.util.Util.getSourceFilePath(element);
    }

    @Override
    public String getRelativePath(String fromPath, String toPath) {
        return org.jsweet.transpiler.util.Util.getRelativePath(fromPath, toPath);
    }

    @Override
    public String getTypeInitialValue(TypeMirror type) {
        if (type == null) {
            return "null";
        }
        if (this.isNumber(type)) {
            return "0";
        }
        if (type.getKind() == TypeKind.BOOLEAN) {
            return "false";
        }
        if (type.getKind() == TypeKind.VOID) {
            return null;
        }
        return "null";
    }

    @Override
    public boolean isInterface(TypeElement type) {
        if (type instanceof Symbol.TypeSymbol) {
            return this.context.isInterface((Symbol.TypeSymbol)((Object)type));
        }
        return false;
    }
}

