/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.TypeChecker;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Position;
import org.jsweet.transpiler.util.SourceMap;

public abstract class AbstractTreePrinter
extends AbstractTreeScanner {
    private Stack<Position> positionStack = new Stack();
    private Set<JCTree> inlinedExpressions = new HashSet<JCTree>();
    public StringBuilder footer = new StringBuilder();
    protected static final String INDENT = "    ";
    private StringBuilder out = new StringBuilder();
    private int indent = 0;
    private PrinterAdapter adapter;
    public TypeChecker typeChecker;
    private int currentLine = 1;
    private int currentColumn = 0;
    private boolean fillSourceMap = true;
    public SourceMap sourceMap = new SourceMap();
    protected boolean inArgListTail = false;

    public boolean isInlinedExpression(JCTree tree) {
        return this.inlinedExpressions.contains(tree);
    }

    public void addInlinedExpression(JCTree tree) {
        this.inlinedExpressions.add(tree);
    }

    public void clearInlinedExpression() {
        this.inlinedExpressions.clear();
    }

    public Stack<Position> getPositionStack() {
        return this.positionStack;
    }

    public AbstractTreePrinter(TranspilationHandler logHandler, JSweetContext context, JCTree.JCCompilationUnit compilationUnit, PrinterAdapter adapter, boolean fillSourceMap) {
        super(logHandler, context, compilationUnit);
        this.typeChecker = new TypeChecker(this);
        this.adapter = adapter;
        this.adapter.setPrinter(this);
        this.fillSourceMap = fillSourceMap;
    }

    protected String getStringLiteralQuote() {
        return this.context.options.isUseSingleQuotesForStringLiterals() ? "'" : "\"";
    }

    public String getOutput() {
        return this.out.toString();
    }

    public AbstractTreePrinter print(JCTree tree) {
        this.scan(tree);
        return this;
    }

    @Override
    protected void enter(JCTree tree) {
        super.enter(tree);
        this.positionStack.push(new Position(this.getCurrentPosition(), this.currentLine, this.currentColumn));
        if (this.compilationUnit != null && tree.pos >= 0 && this.inSourceMap(tree)) {
            this.sourceMap.addEntry(new Position(tree.pos, this.compilationUnit.lineMap.getLineNumber(tree.pos), this.compilationUnit.lineMap.getColumnNumber(tree.pos)), this.positionStack.peek());
        }
    }

    private boolean inSourceMap(JCTree tree) {
        return tree instanceof JCTree.JCExpression || tree instanceof JCTree.JCStatement || tree instanceof JCTree.JCMethodDecl;
    }

    @Override
    protected void onRollbacked(JCTree target) {
        super.onRollbacked(target);
        Position position = this.positionStack.peek();
        this.out.delete(position.getPosition(), this.out.length());
        this.currentColumn = position.getColumn();
        this.currentLine = position.getLine();
    }

    @Override
    protected void exit() {
        JCTree tree = (JCTree)this.stack.peek();
        if (this.compilationUnit != null && tree instanceof JCTree.JCBlock) {
            int endPos = tree.getEndPosition(this.diagnosticSource.getEndPosTable());
            this.sourceMap.addEntry(new Position(endPos, this.compilationUnit.lineMap.getLineNumber(endPos), this.compilationUnit.lineMap.getColumnNumber(endPos)), new Position(this.getCurrentPosition(), this.currentLine, this.currentColumn));
        }
        super.exit();
        this.positionStack.pop();
    }

    public int getCurrentPosition() {
        return this.out.length();
    }

    public char getLastPrintedChar() {
        return this.out.charAt(this.out.length() - 1);
    }

    public String getLastPrintedString(int length) {
        return this.out.substring(this.out.length() - length);
    }

    public AbstractTreePrinter printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.print(INDENT);
        }
        return this;
    }

    public String getIndentString() {
        String indentString = "";
        for (int i = 0; i < this.indent; ++i) {
            indentString = indentString + INDENT;
        }
        return indentString;
    }

    public AbstractTreePrinter startIndent() {
        ++this.indent;
        return this;
    }

    public AbstractTreePrinter endIndent() {
        --this.indent;
        return this;
    }

    public AbstractTreePrinter print(String string) {
        this.out.append(string);
        this.currentColumn += string.length();
        return this;
    }

    public AbstractTreePrinter println(String string) {
        return this.print(string).println();
    }

    public AbstractTreePrinter printIdentifier(Symbol symbol) {
        String adaptedIdentifier = this.context.getActualName(symbol);
        return this.print(adaptedIdentifier);
    }

    public String getQualifiedTypeName(Symbol.TypeSymbol type, boolean globals, boolean ignoreLangTypes) {
        return this.getRootRelativeName(type);
    }

    public String getIdentifier(Symbol symbol) {
        return this.context.getActualName(symbol);
    }

    public AbstractTreePrinter space() {
        return this.print(" ");
    }

    public boolean removeLastChar(char expectedChar) {
        if (this.getLastPrintedChar() == expectedChar) {
            this.removeLastChar();
            return true;
        }
        return false;
    }

    public AbstractTreePrinter removeLastChar() {
        if (this.out.length() == 0) {
            return this;
        }
        if (this.out.charAt(this.out.length() - 1) == '\n') {
            --this.currentLine;
            this.currentColumn = 0;
        } else {
            --this.currentColumn;
        }
        this.out.deleteCharAt(this.out.length() - 1);
        return this;
    }

    public AbstractTreePrinter removeLastChars(int count) {
        for (int i = 0; i < count; ++i) {
            this.removeLastChar();
        }
        return this;
    }

    public AbstractTreePrinter removeLastIndent() {
        this.removeLastChars(this.indent * INDENT.length());
        return this;
    }

    public AbstractTreePrinter println() {
        this.out.append("\n");
        ++this.currentLine;
        this.currentColumn = 0;
        return this;
    }

    public String getResult() {
        return this.out.toString();
    }

    public PrinterAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(PrinterAdapter adapter) {
        this.adapter = adapter;
    }

    public AbstractTreePrinter printArgList(java.util.List<Type> assignedTypes, java.util.List<? extends JCTree> args, Consumer<JCTree> printer) {
        int i = 0;
        for (JCTree jCTree : args) {
            if (printer != null) {
                printer.accept(jCTree);
            } else if (assignedTypes != null && jCTree instanceof JCTree.JCExpression && i < assignedTypes.size()) {
                if (!this.substituteAssignedExpression(assignedTypes.get(i++), (JCTree.JCExpression)jCTree)) {
                    this.print(jCTree);
                }
            } else {
                this.print(jCTree);
            }
            this.print(", ");
            this.inArgListTail = true;
        }
        this.inArgListTail = false;
        if (!args.isEmpty()) {
            this.removeLastChars(2);
        }
        return this;
    }

    public AbstractTreePrinter substituteAndPrintAssignedExpression(Type assignedType, JCTree.JCExpression expression) {
        if (!this.substituteAssignedExpression(assignedType, expression)) {
            this.print(expression);
        }
        return this;
    }

    protected abstract boolean substituteAssignedExpression(Type var1, JCTree.JCExpression var2);

    public AbstractTreePrinter printArgList(JCTree.JCMethodInvocation inv) {
        for (int i = 0; i < inv.args.size(); ++i) {
            JCTree.JCExpression arg = inv.args.get(i);
            if (inv.meth.type != null) {
                Type paramType;
                List<Type> argTypes = ((Type.MethodType)inv.meth.type).argtypes;
                Type type = paramType = i < argTypes.size() ? (Type)argTypes.get(i) : (Type)argTypes.get(argTypes.size() - 1);
                if (!this.substituteAssignedExpression(paramType, arg)) {
                    this.print(arg);
                }
            }
            if (i >= inv.args.size() - 1) continue;
            this.print(", ");
        }
        return this;
    }

    public AbstractTreePrinter printArgList(java.util.List<Type> assignedTypes, java.util.List<? extends JCTree> args) {
        return this.printArgList(assignedTypes, args, null);
    }

    public abstract AbstractTreePrinter printConstructorArgList(JCTree.JCNewClass var1, boolean var2);

    public abstract AbstractTreePrinter substituteAndPrintType(JCTree var1);

    public AbstractTreePrinter printVarNameList(java.util.List<JCTree.JCVariableDecl> args) {
        for (JCTree.JCVariableDecl arg : args) {
            this.print(arg.name.toString());
            this.print(", ");
        }
        if (!args.isEmpty()) {
            this.removeLastChars(2);
        }
        return this;
    }

    public AbstractTreePrinter printTypeArgList(java.util.List<? extends JCTree> args) {
        for (JCTree jCTree : args) {
            this.substituteAndPrintType(jCTree);
            this.print(", ");
        }
        if (!args.isEmpty()) {
            this.removeLastChars(2);
        }
        return this;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    @Override
    public JCTree.JCCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public boolean isFillSourceMap() {
        return this.fillSourceMap;
    }

    public String getRootRelativeName(Symbol symbol) {
        return this.context.getRootRelativeName(this.context.useModules ? this.context.getImportedElements(this.compilationUnit.getSourceFile().getName()) : null, symbol);
    }

    public String getRootRelativeName(Symbol symbol, boolean useJavaNames) {
        return this.context.getRootRelativeName(this.context.useModules ? this.context.getImportedElements(this.compilationUnit.getSourceFile().getName()) : null, symbol, useJavaNames);
    }

    public int getIndent() {
        return this.indent;
    }
}

